/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fshows.sdk.sf.api.utils;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/**
 * @author zhanyiming
 * @version Misc.java, v 0.1 2021-12-06 18:16 zhanyiming
 */
public class Misc {
    public static final String NONE = "";

    public static final String NULL = "null";

    public static final String UNDEFINED = "undefined";

    public static final Pattern PATTERN = Pattern.compile("[0-9]*");

    public static boolean isNull(Object obj) {
        return Misc.isEmpty(obj);
    }

    public static boolean isNotNull(Object obj) {
        return !Misc.isEmpty(obj);
    }

    /**
     * 对象非空判断
     */
    public static boolean isNotEmpty(Object obj) {
        return !Misc.isEmpty(obj);
    }

    public static boolean isEmpty(Object obj) {
        if (obj == null) {
            return true;
        }

        if (obj instanceof String) {
            String str = obj.toString().trim();
            if (NONE.equals(str) || NULL.equals(str) || UNDEFINED.equals(str)) {
                return true;
            }
        }
        if (obj.getClass().isArray()) {
            return Array.getLength(obj) == 0;
        }
        if (obj instanceof CharSequence) {
            return ((CharSequence) obj).length() == 0;
        }
        if (obj instanceof Collection) {
            return ((Collection) obj).isEmpty();
        }
        if (obj instanceof Map) {
            return ((Map) obj).isEmpty();
        }
        // else
        return false;
    }

    /**
     * 判断字符串是否为数字 纯数字return:true 否则false
     */
    public static boolean isNumeric(String str) {
        if (isNull(str)) {
            return false;
        }
        Matcher isNum = PATTERN.matcher(str);
        return isNum.matches();
    }

    /**
     * 将英文逗号拼接的字符转换为 Set<String>
     */
    public static Set<String> string2Set(String values, String split) {
        Set<String> set = new HashSet();
        if (isNull(values)) {
            return set;
        }
        values = values.replace("，", ",");
        StringTokenizer st = new StringTokenizer(values, split);
        while (st.hasMoreTokens()) {
            String value = st.nextToken().trim();
            if (!isNull(value)) {
                set.add(value);
            }
        }
        return set;
    }
}