/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.response;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version CancelOrderResponse.java, v 0.1 2022-01-10 1:40 下午 jinbo
 */
@Data
public class CancelOrderResponse extends SfResponse<SfResponse> {
    private static final long serialVersionUID = 6334468251290550400L;

    @JSONField(name = "sf_order_id")
    private String sfOrderId;

    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    @JSONField(name = "deduction_detail")
    private DeductionDetail deductionDetail;

    @JSONField(name = "push_time")
    private Integer pushTime;

    @lombok.Data
    public class DeductionDetail {
        /**
         * 取消收费金额（单位：分）
         */
        @JSONField(name = "deduction_fee")
        private Integer deduction_fee;

        /**
         * 店铺维度累计的取消次数
         */
        @JSONField(name = "shop_cancel_times")
        private Integer shopCancelTimes;

        /**
         * 配置的免费取消次数
         */
        @JSONField(name = "free_cancel_times")
        private Integer freeCancelTimes;
    }

}