/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.ReminderOrderResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version ReminderOrderRequest.java, v 0.1 2022-01-11 11:33 上午 jinbo
 */
@Data
public class ReminderOrderRequest extends BaseRequest implements SfRequest<ReminderOrderResponse> {

    /**
     * 订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单id类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺id，order_type=2时必传shop_id与shop_type
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺id类型
     */
    @JSONField(name = "shop_type")
    private Integer shopType;


    /**
     * 推送时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;


    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.REMINDER_ORDER;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<ReminderOrderResponse> getResponseClazz() {
        return ReminderOrderResponse.class;
    }
}