/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.PreCancelOrderResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version PreCancelOrderRequest.java, v 0.1 2022-01-10 4:00 下午 jinbo
 */
@Data
public class PreCancelOrderRequest extends BaseRequest implements SfRequest<PreCancelOrderResponse> {

    /**
     * 订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单id类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺id，order_type=2时必传shop_id与shop_type
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺id类型
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 其他取消原因
     */
    @JSONField(name = "cancel_reason")
    private String cancelReason;

    /**
     * 取消时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;


    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.PRECANCEL_ORDER;

    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<PreCancelOrderResponse> getResponseClazz() {
        return PreCancelOrderResponse.class;
    }
}