/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.NotifyProductReadyResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version NotifyProductReadyRequest.java, v 0.1 2022-01-12 10:31 上午 jinbo
 */
@Data
public class NotifyProductReadyRequest  extends BaseRequest implements SfRequest<NotifyProductReadyResponse> {

    /**
     * 订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单id类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺id，order_type=2时必传shop_id与shop_type
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺id类型,1表示顺丰店铺id、2表示接入方店铺id
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 货物准备好时间，秒级时间戳
     */
    @JSONField(name = "notice_ready_time")
    private Integer noticeReadyTime;

    /**
     * 推送时间，秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.NOTIFY_PRODUCT_READY;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<NotifyProductReadyResponse> getResponseClazz() {
        return NotifyProductReadyResponse.class;
    }
}