/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.GetShopAccountBalanceResponse;
import lombok.Data;

/**
 * @author zhanyiming
 * @version getshopaccountbalanceRequest.java, v 0.1 2021-12-09 14:10 zhanyiming
 */
@Data
public class GetShopAccountBalanceRequest extends BaseRequest implements SfRequest<GetShopAccountBalanceResponse> {

    /**
     * 店铺ID
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 请求时间 (秒级时间戳)
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    /**
     * 店铺类型
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.GET_SHOP_ACCOUNT_BALANCE;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<GetShopAccountBalanceResponse> getResponseClazz() {
        return GetShopAccountBalanceResponse.class;
    }
}