/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.CreateOrderResponse;
import lombok.Data;

import java.util.List;

/**
 * @author zhanyiming
 * @version CreateOrderRequest.java, v 0.1 2021-12-09 15:04 zhanyiming
 */
@Data
public class CreateOrderRequest extends BaseRequest implements SfRequest<CreateOrderResponse> {

    /**
     * 店铺ID
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺ID类型; 1：顺丰店铺ID ；2：接入方店铺ID
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 商家订单号	 不允许重复
     */
    @JSONField(name = "shop_order_id")
    private String shopOrderId;

    /**
     * 商家预计备餐时长;分钟级时间 比如: 10 分钟 则传入 10
     */
    @JSONField(name = "shop_preparation_time")
    private Integer shopPreparationTime;

    /**
     * 订单接入来源；1：美团；2：饿了么；3：百度；4：口碑；
     * 其他请直接填写中文字符串值
     */
    @JSONField(name = "order_source")
    private String orderSource;

    /**
     * 取货序号	与order_source配合使用 如：饿了么10号单，表示如下：
     * order_source=2;order_sequence=10。
     * 用于骑士快速寻找配送物
     */
    @JSONField(name = "order_sequence")
    private  String orderSequence;

    /**
     * 坐标类型；1：百度坐标，2：高德坐标
     */
    @JSONField(name = "lbs_type")
    private Integer lbsType;

    /**
     * 用户支付方式; 1：已付款 0：货到付款
     */
    @JSONField(name = "pay_type")
    private Integer payType;

    /**
     * 用户下单时间;秒级时间戳
     */
    @JSONField(name = "order_time")
    private Integer orderTime;

    /**
     * 是否是预约单; 0：非预约单；1：预约单
     */
    @JSONField(name = "is_appoint")
    private Integer isAppoint;

    /**
     * 预约单类型	; 预约单的时候传入,1：预约单送达单；2：预约单上门单
     */
    @JSONField(name = "appoint_type")
    private Integer appointType;

    /**
     * 用户期望送达时间; 若传入自此段且时间大于配送时效，则按照预约送达单处理，时间小于配送时效按照立即单处理；appoint_type=1时需必传,秒级时间戳；
     */
    @JSONField(name = "expect_time")
    private Integer expectTime;

    /**
     * 用户期望上门时间	appoint_type=2时需必传,秒级时间戳
     */
    @JSONField(name = "expect_pickup_time")
    private Integer expectPickupTime;

    /**
     * 商家期望送达时间	只展示给骑士，不参与时效考核；秒级时间戳
     */
    @JSONField(name = "shop_expect_time")
    private Integer shopExpectTime;

    /**
     * 是否保价，0：非保价；1：保价
     */
    @JSONField(name = "is_insured")
    private Integer isInsured;

    /**
     * 是否是专人直送订单，0：否；1：是
     */
    @JSONField(name = "is_person_direct")
    private Integer isPersonDirect;

    /**
     * 配送交通工具，0：否；1：电动车；2：小轿车
     */
    @JSONField(name = "vehicle")
    private Integer vehicle;

    /**
     * 保价金额	单位：分
     */
    @JSONField(name = "declared_value")
    private Integer declaredValue;

    /**
     * 订单小费，不传或者传0为不加小费  单位分，加小费最低不能少于100分
     */
    @JSONField(name = "gratuity_fee")
    private Integer gratuityFee;

    /**
     * 订单备注
     */
    @JSONField(name = "remark")
    private String remark;

    /**
     * 物流流向	1：从门店取件送至用户；2：从用户取件送至门店
     */
    @JSONField(name = "rider_pick_method")
    private Integer riderPickMethod;

    /**
     * 返回字段控制标志位（二进制）	1:商品总价格，2:配送距离，4:物品重量，8:起送时间，16:期望送达时间，32:支付费用，64:实际支持金额，128:优惠卷总金额，256:结算方式
     * 例如全部返回为填入511
     */
    @JSONField(name = "return_flag")
    private Integer returnFlag;

    /**
     * 推单时间	秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    /**
     * 版本号	照文档主版本号填写
     * 如：文档版本号1.7,version=17
     */
    @JSONField(name = "version")
    private Integer version;

    /**
     * 收货人信息
     */
    @JSONField(name = "receive")
    private ReceiveRequest receive;

    /**
     * 发货店铺信息
     */
    @JSONField(name = "shop")
    private ShopRequest shop;

    /**
     * 订单详情
     */
    @JSONField(name = "order_detail")
    private OrderDetailRequest orderDetail;

    /**
     * 多点取货信息
     */
    @JSONField(name = "multi_pickup_info")
    private List<MultiPickupInfoRequest> multiPickupInfo;



    @lombok.Data
    public static class ReceiveRequest {

        /**
         * 用户姓名
         */
        @JSONField(name = "user_name")
        private String userName;

        /**
         * 用户电话
         */
        @JSONField(name = "user_phone")
        private String userPhone;

        /**
         * 用户地址
         */
        @JSONField(name = "user_address")
        private String userAddress;

        /**
         * 用户经度
         */
        @JSONField(name = "user_lng")
        private String userLng;

        /**
         * 用户纬度
         */
        @JSONField(name = "user_lat")
        private String userLat;

        /**
         * 发单城市
         */
        @JSONField(name = "city_name")
        private String cityName;

    }

    @lombok.Data
    public static class ShopRequest {

        /**
         * 店铺名称
         */
        @JSONField(name = "shop_name")
        private String shopName;

        /**
         * 店铺电话
         */
        @JSONField(name = "shop_phone")
        private String shopPhone;

        /**
         * 店铺地址
         */
        @JSONField(name = "shop_address")
        private String shopAddress;

        /**
         * 店铺经度
         */
        @JSONField(name = "shop_lng")
        private String shopLng;

        /**
         * 店铺纬度
         */
        @JSONField(name = "shop_lat")
        private String shopLat;
    }

    @lombok.Data
    public static class OrderDetailRequest {

        /**
         * 用户订单商品总金额（单位：分）
         */
        @JSONField(name = "total_price")
        private Integer totalPrice;

        /**
         * 物品类型
         */
        @JSONField(name = "product_type")
        private Integer productType;

        /**
         * 用户实付商家金额（单位：分）
         */
        @JSONField(name = "user_money")
        private Integer userMoney;

        /**
         * 商家实收用户金额（单位：分）
         */
        @JSONField(name = "shop_money")
        private Integer shopMoney;

        /**
         * 物品重量（单位：克） 100 表示100g
         */
        @JSONField(name = "weight_gram")
        private Integer weightGram;

        /**
         * 物品体积（单位：升） 1 表示1升
         */
        @JSONField(name = "volume_litre")
        private Integer volumeLitre;

        /**
         * 商家收取用户的配送费（单位：分） 100 表示1元
         */
        @JSONField(name = "delivery_money")
        private Integer deliveryMoney;

        /**
         * 物品个数
         */
        @JSONField(name = "product_num")
        private Integer productNum;

        /**
         * 物品种类个数
         */
        @JSONField(name = "product_type_num")
        private Integer productTypeNum;

        /**
         * 物品详情；
         */
        @JSONField(name = "product_detail")
        private List<ProductDetailRequest> productDetail;
    }

    @lombok.Data
    public static class ProductDetailRequest {

        /**
         * 物品名称
         */
        @JSONField(name = "product_name")
        private String productName;

        /**
         * 物品ID
         */
        @JSONField(name = "product_id")
        private Integer productId;

        /**
         * 物品数量
         */
        @JSONField(name = "product_num")
        private Integer productNum;

        /**
         * 物品价格
         */
        @JSONField(name = "product_price")
        private Integer productPrice;

        /**
         * 物品单位
         */
        @JSONField(name = "product_unit")
        private String productUnit;

        /**
         * 备注
         */
        @JSONField(name = "product_remark")
        private String productRemark;

        /**
         * 详情
         */
        @JSONField(name = "item_detail")
        private String itemDetail;
    }

    @lombok.Data
    public class MultiPickupInfoRequest {

        /**
         * 取货点地址
         */
        @JSONField(name = "pickup_shop_address")
        private String pickupShopAddress;

        /**
         * 取货点店铺手机号
         */
        @JSONField(name = "pickup_shop_phone")
        private String pickupShopPhone;

        /**
         * 取货点店铺名称
         */
        @JSONField(name = "pickup_shop_name")
        private String pickupShopName;

        /**
         * 取货点经度
         */
        @JSONField(name = "pickup_lng")
        private String pickupLng;

        /**
         * 取货点纬度
         */
        @JSONField(name = "pickup_lat")
        private String pickupLat;

        /**
         * 取货点店铺物品信息
         */
        @JSONField(name = "pickup_products")
        private String pickupProducts;
    }



    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.CREATE_ORDER;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<CreateOrderResponse> getResponseClazz() {
        return CreateOrderResponse.class;
    }


}