/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.ChangeOrderResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version ChangeOrderRequest.java, v 0.1 2022-01-11 11:09 上午 jinbo
 */
@Data
public class ChangeOrderRequest extends BaseRequest implements SfRequest<ChangeOrderResponse> {

    /**
     * 订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单id类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 订单接入来源，1：美团；2：饿了么；3：百度；4：口碑；其他请直接填写中文字符串值
     */
    @JSONField(name = "order_source")
    private String orderSource;

    /**
     * 取货序号，与order_source配合使用如：饿了么10号单，表示如下：order_source=2;order_sequence=10。用于骑士快速寻找配送物
     */
    @JSONField(name = "order_sequence")
    private String orderSequence;

    /**
     * 店铺ID
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺ID类型; 1：顺丰店铺ID ；2：接入方店铺ID
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 用户姓名
     */
    @JSONField(name = "user_name")
    private String userName;

    /**
     * 用户电话
     */
    @JSONField(name = "user_phone")
    private String userPhone;

    /**
     * 用户地址
     */
    @JSONField(name = "user_address")
    private String userAddress;

    /**
     * 坐标类型 1：百度坐标，2：高德坐标（默认值为2，下面的经纬度依赖这个坐标系，不传默认高德）
     */
    @JSONField(name = "lbs_type")
    private Integer lbsType;
    //传入用户地址经纬度顺丰侧则不根据用户地址解析
    /**
     * 用户地址经度
     */
    @JSONField(name = "user_lng")
    private String userLng;

    /**
     * 用户地址纬度
     */
    @JSONField(name = "user_lat")
    private String userLat;

    /**
     * 取消时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    /**
     * 订单备注
     */
    @JSONField(name = "remark")
    private String remark;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.CHANGE_ORDER;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<ChangeOrderResponse> getResponseClazz() {
        return ChangeOrderResponse.class;
    }
}