/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.request;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.SfRequest;
import com.fshows.sdk.sf.api.config.SfApiUrlConstant;
import com.fshows.sdk.sf.api.response.CancelOrderResponse;
import lombok.Data;

/**
 * @author jinbo
 * @version CancelOrderRequest.java, v 0.1 2022-01-10 1:40 下午 jinbo
 */
@Data
public class CancelOrderRequest extends BaseRequest implements SfRequest<CancelOrderResponse> {

    /**
     * 订单id
     */
    @JSONField(name = "order_id")
    private String orderId;

    /**
     * 查询订单id类型，1、顺丰订单号 2、商家订单号
     */
    @JSONField(name = "order_type")
    private Integer orderType;

    /**
     * 店铺id，order_type=2时必传shop_id与shop_type
     */
    @JSONField(name = "shop_id")
    private String shopId;

    /**
     * 店铺id类型
     */
    @JSONField(name = "shop_type")
    private Integer shopType;

    /**
     * 取消原因代码；不填时默认cancel_code=313,cancel_reason=商家发起取消
     */
    @JSONField(name = "cancel_code")
    private Integer cancelCode;

    /**
     * 其他取消原因
     */
    @JSONField(name = "cancel_reason")
    private String cancelReason;

    /**
     * 取消时间；秒级时间戳
     */
    @JSONField(name = "push_time")
    private Integer pushTime;

    @Override
    public String getApiMethodName() {
        return SfApiUrlConstant.CANCEL_ORDER;
    }

    @Override
    public String getBusinessParam() {
        return JSON.toJSONString(this);
    }

    @Override
    public Class<CancelOrderResponse> getResponseClazz() {
        return CancelOrderResponse.class;
    }


}