/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.exception;

import com.fshows.sdk.sf.api.enums.OrderExceptionEnum;

import java.text.MessageFormat;

/**
 * @author jinbo
 * @version SfException.java, v 0.1 2022-01-07 9:20 上午 jinbo
 */
public class SfApiException extends Exception{

    private static final long serialVersionUID = -433786329905855327L;

    protected Integer errorCode;
    protected String errorMsg;

    public SfApiException(Throwable cause) {
        super(cause);
    }

    private SfApiException(OrderExceptionEnum sfExceptionEnum) {
        this(sfExceptionEnum.getCode(), sfExceptionEnum.getMsg());
    }

    public SfApiException() {
    }

    public SfApiException(Integer errorCode, String errorMsg) {
        super(errorCode + ":" + errorMsg);
        this.errorCode = errorCode;
        this.errorMsg = errorMsg;
    }

    public SfApiException newInstance(String msgFormat, Object... args) {
        return new SfApiException(errorCode, MessageFormat.format(msgFormat, args));
    }

    /**
     * Getter method for property <tt>errorCode</tt>.
     *
     * @return property value of errorCode
     */
    public Integer getErrorCode() {
        return errorCode;
    }

    /**
     * Setter method for property <tt>errorCode</tt>.
     *
     * @param errorCode value to be assigned to property errorCode
     */
    public void setErrorCode(Integer errorCode) {
        this.errorCode = errorCode;
    }

    /**
     * Getter method for property <tt>errorMsg</tt>.
     *
     * @return property value of errorMsg
     */
    public String getErrorMsg() {
        return errorMsg;
    }

    /**
     * Setter method for property <tt>errorMsg</tt>.
     *
     * @param errorMsg value to be assigned to property errorMsg
     */
    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }
}