/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.enums;

/**
 * @author zhanyiming
 * @version SfResultCodeEnum.java, v 0.1 2021-12-09 14:50 zhanyiming
 */
public enum SfResultCodeEnum {
    /**
     * 返回值code枚举
     */
    SUCCESS(0, "SUCCESS"),

    /**
     * 9999：返回值为空
     */
    RESULT_IS_NULL(9999,"顺丰接口返回值为空异常"),

    /*************对外：只要有异常都是顺丰异常，对内：通过code细分具体问题****************/
    /**
     * 8885, 结果序列化异常
     */
    SF_SERIAL_ERROR(8885,"顺丰接口异常"),
    /**
     * 8886,只要调用顺丰接口没正常拿到结果，都是顺丰接口异常
     */
    SF_EXCEPTION(8886,"顺丰接口异常"),
    /**
     * 8887,io异常
     */
    SF_IO_ERROR(8887,"顺丰接口异常"),
    /**
     * 8888,异常
     */
    SF_ERROR(8888,"顺丰接口异常"),

    ;

    private Integer code;
    private String value;

    SfResultCodeEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public static SfResultCodeEnum getByCode(Integer code) {
        SfResultCodeEnum[] valueList = SfResultCodeEnum.values();
        for (SfResultCodeEnum v : valueList) {
            if (v.getValue().equals(code)) {
                return v;
            }
        }
        return null;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public Integer getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }

}
    