/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.enums;

/**
 * @author jinbo
 * @version ProductTypeEnum.java, v 0.1 2022-01-06 5:34 下午 jinbo
 */
public enum ProductTypeEnum {
    //1:快餐
    FAST_FOOD("快餐", 1),
    //2:药品
    DRUG("药品", 2),
    //3:百货
    DEPARTMENT("百货", 3),
    //4:脏衣服收
    DIRTY_CLOTHES_RECEIVE("脏衣服收", 4),
    //5:干净衣服派
    CLEAN_CLOTHES_SEND("干净衣服派", 5),
    //6:生鲜
    FRESH("生鲜", 6),
    //8:高端饮品
    HIGH_END_DRINKS("高端饮品",8),
    //9:现场勘验
    SITE_SURVEY("现场勘验", 9),
    //10:快递
    EXPRESS("快递", 10),
    //12:文件
    FILE("文件",12),
    //13:蛋糕
    CAKE("蛋糕", 13),
    //14:鲜花
    FLOWERS("鲜花",14),
    //15:数码
    TECHNO("数码",15),
    //16:服装
    CLOTHES("服装",16),
    //17:汽配
    AUTO_PARTS("汽配", 17),
    //18:珠宝
    JEWELERY("珠宝",18),
    //20:披萨
    PIZZA("披萨", 20),
    //21:中餐
    CHINESE_FOOD("中餐", 21),
    //22:水产
    AQUATIC("水产", 22),
    //27:专人直送
    SOMEONE_SEND_STRAIGHT("专人直送", 27),
    //32:中端饮品
    MID_LEVEL_DRINKS("中端饮品", 32),
    //33:便利店
    FAMILY_MART("便利店", 33),
    //34:面包糕点
    BREAD("面包糕点", 34),
    //35:火锅
    HOT_POT("火锅", 35),
    //36:证照
    LICENSE("证照", 36),
    //41:外部落地配
    OUT_GROUND("外部落地配", 41),
    //48:成人用品
    ADULT_PRODUCTS("成人用品", 48),
    //99:其他
    OTHER("其他", 99),




    ;

    private String name;
    private Integer value;

    ProductTypeEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public Integer getValue() {
        return value;
    }

    public static ProductTypeEnum getByValue(Integer value) {
        ProductTypeEnum[] valueList = values();
        for (ProductTypeEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }

    /**
     * 通过类型获取描述
     *
     * @param value
     * @return
     */
    public static String forName(Integer value) {
        ProductTypeEnum[] valueList = ProductTypeEnum.values();
        for (ProductTypeEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v.getName();
            }
        }
        return null;
    }
}