/**
 * fshows.com
 * Copyright (C) 2013-2022 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.enums;

/**
 * 顺丰订单取件派送状态枚举
 *
 * @author jinbo
 * @version OrderStatusEnum.java, v 0.1 2022-01-11 9:36 上午 jinbo
 */
public enum OrderStatusEnum {
    ORDER_CREATE("订单创建", 1),
    ORDER_CANCEL("订单取消", 2),
    DELIVERY_CLERK_RECEIVE_ORDER("配送员接单", 10),
    DELIVERY_CLERK_AT_SHOP("配送员到店", 12),
    DELIVERY_CLERK_IS_SENDING("配送员配送中（已发货）", 15),
    DELIVERY_CLERK_COMPLETE_ORDER("配送员完成订单", 17),


    ;

    private String name;
    private Integer value;

    OrderStatusEnum(String name, Integer value) {
        this.name = name;
        this.value = value;
    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public String getName() {
        return name;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public Integer getValue() {
        return value;
    }

    public static OrderStatusEnum getByValue(Integer value) {
        OrderStatusEnum[] valueList = OrderStatusEnum.values();
        for (OrderStatusEnum v : valueList) {
            if (v.getValue().equals(value)) {
                return v;
            }
        }
        return null;
    }
}