/**
 * fshows.com
 * Copyright (C) 2013-2021 All Rights Reserved.
 */
package com.fshows.sdk.sf.api.enums;

import com.fshows.sdk.sf.api.utils.StringUtils;

/**
 * @author zhanyiming
 * @version CancelEnum.java, v 0.1 2021-12-07 10:19 zhanyiming
 */
public enum OrderCancelEnum {

    /**
     * 枚举列表
     */
    PLAN_VARIETY(300, "计划有变，暂时不需要寄件了"),
    INFO_ERROR(302, "填错订单信息，取消后重新提交"),
    RIDER_CANCELED(303, "骑士要求取消"),
    ITEM_MISSING(304, "暂时无法提供待配送物品"),
    ORDER_REPEATED(306, "重复下单，取消此单"),
    HOME_TIME_TOO_LONG(309,"骑士上门时间太长"),
    NOBODY_GET_ORDER(312,"无人接单，换用其他平台寄件"),
    OTHER(313,"其他，请注明原因");

    private Integer code;
    private String value;

    OrderCancelEnum(Integer code, String value) {
        this.code = code;
        this.value = value;
    }

    public static OrderCancelEnum getByValue(String value) {
        OrderCancelEnum[] valueList = OrderCancelEnum.values();
        for (OrderCancelEnum v : valueList) {
            if (StringUtils.equalsIgnoreCase(v.getValue(), value)) {
                return v;
            }
        }
        return null;
    }
//    public static OrderCancelEnum getByCode(Integer code) {
//        OrderCancelEnum[] valueList = OrderCancelEnum.values();
//        for (OrderCancelEnum v : valueList) {
//            if (StringUtils.equalsIgnoreCase(v.getValue(), code)) {
//                return v;
//            }
//        }
//        return null;
//    }

    /**
     * Getter method for property <tt>name</tt>.
     *
     * @return property value of name
     */
    public Integer getCode() {
        return code;
    }

    /**
     * Getter method for property <tt>value</tt>.
     *
     * @return property value of value
     */
    public String getValue() {
        return value;
    }








}