/*
 * Licensed to the Apache Software Foundation (ASF) under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The ASF licenses this file to You under the Apache License, Version 2.0
 * (the "License"); you may not use this file except in compliance with
 * the License.  You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package com.fshows.sdk.sf.api;

import lombok.extern.slf4j.Slf4j;
import org.apache.commons.codec.digest.DigestUtils;

import java.io.FileInputStream;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Locale;
import java.util.Map;

/**
 * @author zhanyiming
 * @version Signer.java, v 0.1 2021-12-07 11:37 zhanyiming
 */
@Slf4j
public class Signer {

    public static String sign(String data, String appid, String devKey) {
        try {
            String toSign = data + "&" + appid + "&" + devKey;
            String md5Hex = DigestUtils.md5Hex(toSign).toLowerCase();
            final byte[] textByte = md5Hex.getBytes(StandardCharsets.UTF_8);
            //编码
            Base64.Encoder encoder = Base64.getEncoder();
            return encoder.encodeToString(textByte);
        } catch (Exception e) {
            System.out.println(false);
        }
        return null;
    }
}