package com.fshows.sdk.sf.api;

import com.alibaba.fastjson.annotation.JSONField;
import com.fshows.sdk.sf.api.enums.SfResultCodeEnum;
import lombok.Data;

import java.io.Serializable;

/**
 * API基础响应信息。
 *
 * @author zhanyiming
 */
@Data
public class SfResponse<E extends SfResponse> implements Serializable {

    private static final long serialVersionUID = -7531288108869228702L;

    @JSONField(name = "error_code")
    private Integer errorCode;

    @JSONField(name = "error_msg")
    private String errorMsg;

    @JSONField(name = "error_data")
    private ErrorDataResponse errorData;

    @JSONField(name = "result")
    private String result;

    private SfResponse<E> data;

    @lombok.Data
    public static class ErrorDataResponse {
        @JSONField(name = "desc")
        private String desc;
    }

    public SfResponse() {
    }

    public SfResponse(SfResultCodeEnum codeEnum) {
        this.errorCode = codeEnum.getCode();
        this.errorMsg = codeEnum.getValue();
    }
}

