/*
 * Decompiled with CFR 0.152.
 */
package com.zkl.atmauthorize.util.assist;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class FileItem {
    private Contract contract;

    public FileItem(File file) {
        this.contract = new LocalContract(file);
    }

    public FileItem(String filePath) {
        this(new File(filePath));
    }

    public FileItem(String fileName, byte[] content) {
        this(fileName, content, (String)null);
    }

    public FileItem(String fileName, byte[] content, String mimeType) {
        this.contract = new ByteArrayContract(fileName, content, mimeType);
    }

    public FileItem(String fileName, InputStream stream) {
        this(fileName, stream, (String)null);
    }

    public FileItem(String fileName, InputStream stream, String mimeType) {
        this.contract = new StreamContract(fileName, stream, mimeType);
    }

    public boolean isValid() {
        return this.contract.isValid();
    }

    public String getFileName() {
        return this.contract.getFileName();
    }

    public String getMimeType() throws IOException {
        return this.contract.getMimeType();
    }

    public long getFileLength() {
        return this.contract.getFileLength();
    }

    public void write(OutputStream output) throws IOException {
        this.contract.write(output);
    }

    private static class StreamContract
    implements Contract {
        private String fileName;
        private InputStream stream;
        private String mimeType;

        public StreamContract(String fileName, InputStream stream, String mimeType) {
            this.fileName = fileName;
            this.stream = stream;
            this.mimeType = mimeType;
        }

        @Override
        public boolean isValid() {
            return this.stream != null && this.fileName != null;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getMimeType() {
            if (this.mimeType == null) {
                return "application/octet-stream";
            }
            return this.mimeType;
        }

        @Override
        public long getFileLength() {
            return 0L;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            try {
                int n;
                byte[] buffer = new byte[4096];
                while (-1 != (n = this.stream.read(buffer))) {
                    output.write(buffer, 0, n);
                }
                if (this.stream != null) {
                    this.stream.close();
                }
            }
            catch (Throwable th) {
                if (this.stream != null) {
                    this.stream.close();
                }
                throw th;
            }
        }
    }

    private static class ByteArrayContract
    implements Contract {
        private String fileName;
        private byte[] content;
        private String mimeType;

        public ByteArrayContract(String fileName, byte[] content, String mimeType) {
            this.fileName = fileName;
            this.content = content;
            this.mimeType = mimeType;
        }

        @Override
        public boolean isValid() {
            return this.content != null && this.fileName != null;
        }

        @Override
        public String getFileName() {
            return this.fileName;
        }

        @Override
        public String getMimeType() {
            if (this.mimeType == null) {
                return "application/octet-stream";
            }
            return this.mimeType;
        }

        @Override
        public long getFileLength() {
            return this.content.length;
        }

        @Override
        public void write(OutputStream output) throws IOException {
            output.write(this.content);
        }
    }

    private static class LocalContract
    implements Contract {
        private File file;

        public LocalContract(File file) {
            this.file = file;
        }

        @Override
        public boolean isValid() {
            return this.file != null && this.file.exists() && this.file.isFile();
        }

        @Override
        public String getFileName() {
            return this.file.getName();
        }

        @Override
        public String getMimeType() {
            return "application/octet-stream";
        }

        @Override
        public long getFileLength() {
            return this.file.length();
        }

        @Override
        public void write(OutputStream output) throws IOException {
            FileInputStream input = null;
            try {
                int n;
                input = new FileInputStream(this.file);
                byte[] buffer = new byte[4096];
                while (-1 != (n = ((InputStream)input).read(buffer))) {
                    output.write(buffer, 0, n);
                }
                if (input != null) {
                    ((InputStream)input).close();
                }
            }
            catch (Throwable th) {
                if (input != null) {
                    ((InputStream)input).close();
                }
                throw th;
            }
        }
    }

    private static interface Contract {
        public boolean isValid();

        public String getFileName();

        public String getMimeType();

        public long getFileLength();

        public void write(OutputStream var1) throws IOException;
    }
}

