/*
 * Decompiled with CFR 0.152.
 */
package com.zkl.atmauthorize.util;

import com.google.common.hash.Hashing;
import com.zkl.atmauthorize.util.Common;
import com.zkl.atmauthorize.util.StreamUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.security.KeyFactory;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Arrays;
import java.util.Base64;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SignUtil {
    public Map<String, String> map = new HashMap<String, String>();

    public Map<String, String> getMap() {
        return this.map;
    }

    public void setValue(String key, String value) {
        this.map.put(key, value);
    }

    public String getValue(String key) {
        return this.map.get(key);
    }

    public String toUrl() {
        Set<String> keySet = this.map.keySet();
        Object[] keyArray = keySet.toArray(new String[keySet.size()]);
        Arrays.sort(keyArray);
        StringBuilder sb = new StringBuilder();
        for (Object k : keyArray) {
            if (this.map.get(k).trim().length() <= 0) continue;
            sb.append((String)k).append("=").append(this.map.get(k).trim()).append("&");
        }
        return sb.substring(0, sb.toString().length() - 1);
    }

    public String getSign() throws Exception {
        return this.md5(this.toUrl() + "&key=!@#$%^qweasdzxcv");
    }

    private String md5(String data) throws Exception {
        return Hashing.md5().hashString((CharSequence)data, StandardCharsets.UTF_8).toString().toUpperCase(Locale.ROOT);
    }

    public static boolean rsaCheckContent(String content, String sign, String publicKey, String charset) throws Exception {
        try {
            BouncyCastleProvider provider = new BouncyCastleProvider();
            Security.insertProviderAt((Provider)provider, 1);
            PublicKey pubKey = SignUtil.getPublicKeyFromX509("RSA", new ByteArrayInputStream(publicKey.getBytes(StandardCharsets.UTF_8)), (Provider)provider);
            Signature signature = Signature.getInstance("SHA256withRSA", (Provider)provider);
            signature.initVerify(pubKey);
            if (Common.isEmpty(charset)) {
                signature.update(content.getBytes());
            } else {
                signature.update(content.getBytes(charset));
            }
            byte[] data = Base64.getDecoder().decode(sign.getBytes());
            return signature.verify(data);
        }
        catch (Exception var6) {
            throw new Exception("RSAcontent = " + content + ",sign=" + sign + ",charset = " + charset, var6);
        }
    }

    public static PublicKey getPublicKeyFromX509(String algorithm, InputStream ins, Provider provider) throws Exception {
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm, provider);
        StringWriter writer = new StringWriter();
        StreamUtil.m1io(new InputStreamReader(ins), writer);
        byte[] key = Base64.getDecoder().decode(writer.toString().getBytes());
        return keyFactory.generatePublic(new X509EncodedKeySpec(key));
    }
}

