/*
 * Decompiled with CFR 0.152.
 */
package com.zkl.atmauthorize.util;

public class Base64 {
    static final int CHUNK_SIZE = 76;
    static final int EIGHTBIT = 8;
    static final int SIXTEENBIT = 16;
    static final int TWENTYFOURBITGROUP = 24;
    static final int FOURBYTE = 4;
    static final int SIGN = -128;
    static final byte PAD = 61;
    static final byte[] CHUNK_SEPARATOR = "\r\n".getBytes();
    static final int BASELENGTH = 255;
    private static byte[] base64Alphabet = new byte[255];
    static final int LOOKUPLENGTH = 64;
    private static byte[] lookUpBase64Alphabet = new byte[64];

    private static boolean isBase64(byte octect) {
        return octect == 61 || base64Alphabet[octect] != -1;
    }

    public static boolean isArrayByteBase64(byte[] arrayOctect) {
        byte[] arrayOctect2 = Base64.discardWhitespace(arrayOctect);
        int length = arrayOctect2.length;
        if (length == 0) {
            return true;
        }
        for (byte b : arrayOctect2) {
            if (Base64.isBase64(b)) continue;
            return false;
        }
        return true;
    }

    public static byte[] encodeBase64(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, false);
    }

    public static byte[] encodeBase64Chunked(byte[] binaryData) {
        return Base64.encodeBase64(binaryData, true);
    }

    public Object decode(Object pObject) throws Exception {
        if (pObject instanceof byte[]) {
            return this.decode((byte[])pObject);
        }
        throw new Exception("Parameter supplied to Base64 decode is not a byte[]");
    }

    public byte[] decode(byte[] pArray) {
        return Base64.decodeBase64(pArray);
    }

    public static byte[] encodeBase64(byte[] binaryData, boolean isChunked) {
        int i;
        int lengthDataBits = binaryData.length * 8;
        int fewerThan24bits = lengthDataBits % 24;
        int numberTriplets = lengthDataBits / 24;
        int nbrChunks = 0;
        int encodedDataLength = fewerThan24bits != 0 ? (numberTriplets + 1) * 4 : numberTriplets * 4;
        if (isChunked) {
            nbrChunks = CHUNK_SEPARATOR.length == 0 ? 0 : (int)Math.ceil((float)encodedDataLength / 76.0f);
            encodedDataLength += nbrChunks * CHUNK_SEPARATOR.length;
        }
        byte[] encodedData = new byte[encodedDataLength];
        int encodedIndex = 0;
        int nextSeparatorIndex = 76;
        int chunksSoFar = 0;
        for (i = 0; i < numberTriplets; ++i) {
            int dataIndex = i * 3;
            byte b1 = binaryData[dataIndex];
            byte b2 = binaryData[dataIndex + 1];
            byte b3 = binaryData[dataIndex + 2];
            byte l = (byte)(b2 & 0xF);
            byte k = (byte)(b1 & 3);
            byte val1 = (b1 & 0xFFFFFF80) == 0 ? (byte)(b1 >> 2) : (byte)(b1 >> 2 ^ 0xC0);
            byte val2 = (b2 & 0xFFFFFF80) == 0 ? (byte)(b2 >> 4) : (byte)(b2 >> 4 ^ 0xF0);
            byte val3 = (b3 & 0xFFFFFF80) == 0 ? (byte)(b3 >> 6) : (byte)(b3 >> 6 ^ 0xFC);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val1];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val2 | k << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l << 2 | val3];
            encodedData[encodedIndex + 3] = lookUpBase64Alphabet[b3 & 0x3F];
            if (!isChunked || (encodedIndex += 4) != nextSeparatorIndex) continue;
            System.arraycopy(CHUNK_SEPARATOR, 0, encodedData, encodedIndex, CHUNK_SEPARATOR.length);
            nextSeparatorIndex = 76 * (++chunksSoFar + 1) + chunksSoFar * CHUNK_SEPARATOR.length;
            encodedIndex += CHUNK_SEPARATOR.length;
        }
        int dataIndex2 = i * 3;
        if (fewerThan24bits == 8) {
            byte b12 = binaryData[dataIndex2];
            byte k2 = (byte)(b12 & 3);
            encodedData[encodedIndex] = lookUpBase64Alphabet[(b12 & 0xFFFFFF80) == 0 ? (byte)(b12 >> 2) : (byte)(b12 >> 2 ^ 0xC0)];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[k2 << 4];
            encodedData[encodedIndex + 2] = 61;
            encodedData[encodedIndex + 3] = 61;
        } else if (fewerThan24bits == 16) {
            byte b13 = binaryData[dataIndex2];
            byte b22 = binaryData[dataIndex2 + 1];
            byte l2 = (byte)(b22 & 0xF);
            byte k3 = (byte)(b13 & 3);
            byte val12 = (b13 & 0xFFFFFF80) == 0 ? (byte)(b13 >> 2) : (byte)(b13 >> 2 ^ 0xC0);
            byte val22 = (b22 & 0xFFFFFF80) == 0 ? (byte)(b22 >> 4) : (byte)(b22 >> 4 ^ 0xF0);
            encodedData[encodedIndex] = lookUpBase64Alphabet[val12];
            encodedData[encodedIndex + 1] = lookUpBase64Alphabet[val22 | k3 << 4];
            encodedData[encodedIndex + 2] = lookUpBase64Alphabet[l2 << 2];
            encodedData[encodedIndex + 3] = 61;
        }
        if (isChunked && chunksSoFar < nbrChunks) {
            System.arraycopy(CHUNK_SEPARATOR, 0, encodedData, encodedDataLength - CHUNK_SEPARATOR.length, CHUNK_SEPARATOR.length);
        }
        return encodedData;
    }

    public static byte[] decodeBase64(byte[] base64Data) {
        byte[] base64Data2 = Base64.discardNonBase64(base64Data);
        if (base64Data2.length == 0) {
            return new byte[0];
        }
        int numberQuadruple = base64Data2.length / 4;
        int encodedIndex = 0;
        int lastData = base64Data2.length;
        while (base64Data2[lastData - 1] == 61) {
            if (--lastData != 0) continue;
            return new byte[0];
        }
        byte[] decodedData = new byte[lastData - numberQuadruple];
        for (int i = 0; i < numberQuadruple; ++i) {
            int dataIndex = i * 4;
            byte marker0 = base64Data2[dataIndex + 2];
            byte marker1 = base64Data2[dataIndex + 3];
            byte b1 = base64Alphabet[base64Data2[dataIndex]];
            byte b2 = base64Alphabet[base64Data2[dataIndex + 1]];
            if (marker0 != 61 && marker1 != 61) {
                byte b3 = base64Alphabet[marker0];
                byte b4 = base64Alphabet[marker1];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b3 >> 2 & 0xF);
                decodedData[encodedIndex + 2] = (byte)(b3 << 6 | b4);
            } else if (marker0 == 61) {
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
            } else if (marker1 == 61) {
                byte b32 = base64Alphabet[marker0];
                decodedData[encodedIndex] = (byte)(b1 << 2 | b2 >> 4);
                decodedData[encodedIndex + 1] = (byte)((b2 & 0xF) << 4 | b32 >> 2 & 0xF);
            }
            encodedIndex += 3;
        }
        return decodedData;
    }

    static byte[] discardWhitespace(byte[] data) {
        byte[] groomedData = new byte[data.length];
        int bytesCopied = 0;
        block3: for (int i = 0; i < data.length; ++i) {
            switch (data[i]) {
                case 9: 
                case 10: 
                case 13: 
                case 32: {
                    continue block3;
                }
                default: {
                    groomedData[++bytesCopied] = data[i];
                }
            }
        }
        byte[] packedData = new byte[bytesCopied];
        System.arraycopy(groomedData, 0, packedData, 0, bytesCopied);
        return packedData;
    }

    static byte[] discardNonBase64(byte[] data) {
        byte[] groomedData = new byte[data.length];
        int bytesCopied = 0;
        for (int i = 0; i < data.length; ++i) {
            if (!Base64.isBase64(data[i])) continue;
            groomedData[++bytesCopied] = data[i];
        }
        byte[] packedData = new byte[bytesCopied];
        System.arraycopy(groomedData, 0, packedData, 0, bytesCopied);
        return packedData;
    }

    public Object encode(Object pObject) throws Exception {
        if (pObject instanceof byte[]) {
            return this.encode((byte[])pObject);
        }
        throw new Exception("Parameter supplied to Base64 encode is not a byte[]");
    }

    public byte[] encode(byte[] pArray) {
        return Base64.encodeBase64(pArray, false);
    }

    static {
        for (int i = 0; i < 255; ++i) {
            Base64.base64Alphabet[i] = -1;
        }
        for (int i2 = 90; i2 >= 65; --i2) {
            Base64.base64Alphabet[i2] = (byte)(i2 - 65);
        }
        for (int i3 = 122; i3 >= 97; --i3) {
            Base64.base64Alphabet[i3] = (byte)(i3 - 97 + 26);
        }
        for (int i4 = 57; i4 >= 48; --i4) {
            Base64.base64Alphabet[i4] = (byte)(i4 - 48 + 52);
        }
        Base64.base64Alphabet[43] = 62;
        Base64.base64Alphabet[47] = 63;
        for (int i5 = 0; i5 <= 25; ++i5) {
            Base64.lookUpBase64Alphabet[i5] = (byte)(65 + i5);
        }
        int i6 = 26;
        int j = 0;
        while (i6 <= 51) {
            Base64.lookUpBase64Alphabet[i6] = (byte)(97 + j);
            ++i6;
            ++j;
        }
        int i7 = 52;
        int j2 = 0;
        while (i7 <= 61) {
            Base64.lookUpBase64Alphabet[i7] = (byte)(48 + j2);
            ++i7;
            ++j2;
        }
        Base64.lookUpBase64Alphabet[62] = 43;
        Base64.lookUpBase64Alphabet[63] = 47;
    }
}

