/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.atm.function;

import com.fshows.sdk.atm.function.ThrowableConsumer;

public interface Consumer<T> {
    public void accept(T var1);

    public static class Util {
        private Util() {
        }

        public static <T> Consumer<T> andThen(Consumer<? super T> c1, Consumer<? super T> c2) {
            return value -> {
                c1.accept(value);
                c2.accept(value);
            };
        }

        public static <T> Consumer<T> safe(ThrowableConsumer<? super T, Throwable> throwableConsumer) {
            return Util.safe(throwableConsumer, null);
        }

        public static <T> Consumer<T> safe(ThrowableConsumer<? super T, Throwable> throwableConsumer, Consumer<? super T> onFailedConsumer) {
            return value -> {
                block2: {
                    Util.requireNonNull(throwableConsumer);
                    try {
                        throwableConsumer.accept(value);
                    }
                    catch (Throwable var3) {
                        if (onFailedConsumer == null) break block2;
                        onFailedConsumer.accept(value);
                    }
                }
            };
        }

        private static <T> T requireNonNull(T obj) {
            if (obj == null) {
                throw new NullPointerException();
            }
            return obj;
        }
    }
}

