/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.sdk.atm;

import com.fshows.sdk.atm.AtmSdkConstants;
import com.fshows.sdk.atm.function.Supplier;
import com.fshows.sdk.atm.model.MachineCodeModel;
import com.fshows.sdk.atm.model.SecureCodeModel;
import com.google.common.base.Strings;
import com.google.common.hash.Hashing;
import com.zkl.atmauthorize.util.AesEncrypt;
import com.zkl.atmauthorize.util.Common;
import com.zkl.atmauthorize.util.SignUtil;
import com.zkl.atmauthorize.util.WebUtils;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Locale;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class AtmAuthSdk {
    @Nullable
    public static MachineCodeModel getMachineCode(@Nonnull String deviceId, @Nullable String generatedTime) {
        try {
            String sdkDeviceId = AtmAuthSdk.getSdkDeviceId(deviceId);
            if (Strings.isNullOrEmpty((String)sdkDeviceId)) {
                return null;
            }
            if (Strings.isNullOrEmpty((String)generatedTime)) {
                generatedTime = AtmAuthSdk.getCurrentTimeMinute();
            }
            String primitiveCode = String.format(Locale.CHINA, "%s-zsyatmauth-%s", sdkDeviceId, generatedTime);
            String encryptedCode = AesEncrypt.encryptContent(primitiveCode, "AES", "!#@$%^beiscsdzfu", "UTF-8");
            String preCode = encryptedCode + "-zsyatmqweasd";
            String machineCode = Common.md5Password(preCode);
            MachineCodeModel ret = new MachineCodeModel();
            ret.sdkDeviceId = sdkDeviceId;
            ret.deviceId = deviceId;
            ret.primitiveCode = primitiveCode;
            ret.preCode = preCode;
            ret.generatedTime = generatedTime;
            ret.machineCode = machineCode;
            return ret;
        }
        catch (Exception e) {
            System.err.println("\u5f02\u5e38\uff1a\u83b7\u53d6\u673a\u5668\u4fe1\u606f\u5f02\u5e38: " + e + Common.getTrace(e));
            return null;
        }
    }

    @Nullable
    private static String getSdkDeviceId(@Nonnull String deviceId) {
        if (Strings.isNullOrEmpty((String)deviceId)) {
            return null;
        }
        if (deviceId.length() == 16) {
            return deviceId;
        }
        return Supplier.Util.safe(() -> {
            String hashing = Hashing.md5().hashString((CharSequence)deviceId.toUpperCase(Locale.ROOT), StandardCharsets.UTF_8).toString();
            return hashing.substring(8, 24);
        }, null).get();
    }

    public static SecureCodeModel requestMachineCodeSecret(String machineCode) {
        SecureCodeModel model = new SecureCodeModel();
        try {
            String regInfo;
            SignUtil signUtil = new SignUtil();
            signUtil.setValue("machinecode", machineCode);
            signUtil.setValue("time", AtmAuthSdk.getCurrentDateTime());
            signUtil.setValue("sign", Supplier.Util.safe(signUtil::getSign, "").get());
            String url = "https://atm.grs.petrochina.com.cn/gssatmnet/atm/cardservice/getRegisterCode";
            model.regInfo = regInfo = WebUtils.doGet(url + "?" + signUtil.toUrl(), null, "UTF-8");
            if (Strings.isNullOrEmpty((String)regInfo)) {
                return model.setError("\u5931\u8d25:\u672a\u6388\u6743\uff0c\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a,\u673a\u5668\u7801:" + machineCode + ",\u73af\u5883:" + url.substring(0, 35));
            }
            if (regInfo.contains("\u5931\u8d25")) {
                return model.setError("\u5931\u8d25:\u672a\u6388\u6743" + regInfo + "\u673a\u5668\u7801:" + machineCode + ",\u73af\u5883:" + url.substring(0, 35));
            }
            boolean checkResult = SignUtil.rsaCheckContent(machineCode, regInfo.trim(), "MIGfMA0GCSqGSIb3DQEBAQUAA4GNADCBiQKBgQCkuSAe7yb82BkaxoyQdPbtIo+kGOOx0DvrlXygiGcdip6cGjkb7OlO5Nk0nhOntCBWyNnX8S5utBlbIwK4MNGOvqREAMhELDT5yQa2msujxEq8er76AjtqjQLOdq+yidvTknu5cwwdburiBsVWkUG8gaype7QkqlaePggGd7ccGQIDAQAB", "UTF-8");
            if (!checkResult) {
                return model.setError("\u5931\u8d25:\u672a\u6388\u6743\uff0c\u6821\u9a8c\u7b7e\u540d\u5931\u8d25\uff0c" + regInfo + "\uff0c\u673a\u5668\u7801:" + machineCode + ",\u73af\u5883:" + url.substring(0, 35));
            }
            String expireTime = LocalDateTime.now().plusSeconds(1800L).format(AtmSdkConstants.REQUEST_DATE_TIME_MINUTES_FORMATTER);
            String primitiveSecretCode = machineCode + "@" + expireTime;
            String secretCode = Supplier.Util.safe(() -> AesEncrypt.encryptContent(primitiveSecretCode, "AES", "!#@$%^beiscsdzfu", "UTF-8"), "").get();
            return model.setSuccess(secretCode, primitiveSecretCode, expireTime);
        }
        catch (Throwable t) {
            return model.setError(Supplier.Util.safe(t::getMessage, t.toString()).get());
        }
    }

    private static String getCurrentTimeMinute() {
        return LocalDateTime.now().format(AtmSdkConstants.MACHINE_CODE_DATE_TIME_MINUTES_FORMATTER);
    }

    private static String getCurrentDateTime() {
        return LocalDateTime.now().format(AtmSdkConstants.REQUEST_DATE_TIME_MINUTES_FORMATTER);
    }
}

