/*
 * ailike.com
 * Copyright (C) 2022-2025 All Rights Reserved.
 */
package com.fshows.postar.response.merchant;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author zhangling
 * @version PostarBindPosRes.java, v 0.1 2025-12-09 14:20 zhangling
 */
@Data
public class PostarBindPosRes extends PostarBizRes {

    /**
     * 商户号
     */
    private String custId;
    /**
     * 设备SN
     */
    private String sn;
    /**
     * 终端编号
     */
    private String terCode;
    /**
     * 绑定状态
     * 02：已绑定
     */
    private String status;
    /**
     * 签约标识
     * 0：否、1：签约中、2：未签约
     */
    private String isSign;
    /**
     * 签约二维码链接
     */
    private String signUrl;
    /**
     * 签约方案
     */
    private String signSolution;
    /**
     * 签约任务ID
     */
    private String signTaskId;
    /**
     * 星质标识
     * 0：无奖励
     */
    private String bindAwardFlag;
}