/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 合作状态调整(XZY020)请求
 *
 * @author wangyi
 * @version PostarEditCustomerStatusReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEditCustomerStatusReq extends PostarBaseReq {

    /**
     * 分账功能管理商户编号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 商户编号
     * 分账商户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String custId;

    /**
     * 客户编号
     * 分账接收方客户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String customerId;

    /**
     * 客户状态
     * 1开启，2合作终止
     * 必填: 是
     */
    @NotBlank
    private String customerStatus;

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;
}
