/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.response.share.withdraw;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * 提现-客户(XZY034)响应
 *
 * @author wangyi
 * @version PostarCustomerWithdrawRes.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarCustomerWithdrawRes extends PostarBizRes {

    /**
     * 客户号
     */
    private String customerId;

    /**
     * 600商户号
     */
    private String custId;

    /**
     * 到账金额：分
     */
    private Long txAmt;

    /**
     * 手续费：分
     */
    private Long fee;

    /**
     * 原提现金额：分
     */
    private Long oriTxAmt;

    /**
     * 提现流水号
     */
    private String withId;

    /**
     * 到账状态: 0-待发起 1-处理中 2-已到账 3-到账失败 4-异常
     */
    private String arrivalStatus;

    /**
     * 到账时间：2025-09-26 01:05:37
     */
    private String arrivalTime;

    /**
     * 描述
     */
    private String arrivalMsg;

    /**
     * 结算卡号
     */
    private String cardNo;
}
