/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

/**
 * 订单查询(XZY015)请求
 *
 * @author wangyi
 * @version PostarSplitQueryReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSplitQueryReq extends PostarBaseReq {

    /**
     * 三方订单号
     * 三方订单号和分账流水号二选一
     * 必填: 否
     */
    private String otherOrderNo;

    /**
     * 分账流水号
     * 三方订单号和分账流水号二选一
     * 必填: 否
     */
    private String tradeId;

    /**
     * 交易时间
     * 格式:yyyymmdd，半年内订单可不传时间
     * 必填: 否
     */
    private String tradeTime;
}
