/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.split;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 分账合并入账电子回单下载(XZY039)请求
 *
 * @author wangyi
 * @version PostarSplitMergeReceiptReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarSplitMergeReceiptReq extends PostarBaseReq {

    /**
     * 开通分账/归集功能的600商户号
     * 必填: 是
     */
    @NotBlank
    private String mainCustId;

    /**
     * 合并入账商户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String custId;

    /**
     * 合并入账客户号
     * 商户号、客户号二选一
     * 必填: 否
     */
    private String customerId;

    /**
     * 入账时间
     * 格式:yyyymmdd，半年内订单可不传时间
     * 必填: 否
     */
    private String tradeTime;
}
