/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product.detail;

import lombok.Data;

/**
 * 开票信息
 *
 * @author wangyi
 * @version InvoiceProductInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class InvoiceProductInfo {

    /**
     * 开票类型
     * 0-电子专票，1-电子普票
     * 必填: 否
     */
    private Integer invoiceType;

    /**
     * 发票抬头
     * 必填: 否
     */
    private String comName;

    /**
     * 税号
     * 必填: 否
     */
    private String comTaxId;

    /**
     * 开户行
     * 必填: 否
     */
    private String branceCode;

    /**
     * 银行账号
     * 必填: 否
     */
    private String accCode;

    /**
     * 营业执照地址
     * 必填: 否
     */
    private String address;

    /**
     * 联系电话
     * 必填: 否
     */
    private String tel;

    /**
     * 付款凭证
     * 必填: 否
     */
    private String paymentImg;
}
