/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product.detail;

import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * 编辑产品基础信息
 *
 * @author wangyi
 * @version EditBasicProductInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class EditBasicProductInfo {

    /**
     * 分账地区城市id
     * 必填: 是
     */
    @NotBlank
    private String cityId;

    /**
     * 商户方/归集方最大分账比例
     * 单位：%
     * 必填: 是
     */
    @NotBlank
    private String maxSplitRatio;

    /**
     * 开通说明
     * 必填: 否
     */
    private String note;

    /**
     * 分账地区省市id
     * 必填: 是
     */
    @NotBlank
    private String provinceId;

    /**
     * 产品开通异步通知地址
     * 必填: 否
     */
    private String notifyUrl;
}
