/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.product.detail;

import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;

/**
 * 产品基础信息
 *
 * @author wangyi
 * @version BasicProductInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class BasicProductInfo {

    /**
     * 分账场景
     * 0-夜市类，1-珠宝工艺品类，2-股东财务类，3-医美类，4-酒吧夜店，5-其他
     * 必填: 是
     */
    @NotBlank
    private String accSplitSence;

    /**
     * 分账场景其他
     * 分账场景为其他时可填写
     * 必填: 否
     */
    private String accSplitSenceAdd;

    /**
     * 分账地区城市id
     * 必填: 是
     */
    @NotBlank
    private String cityId;

    /**
     * 商户方/归集方最大分账比例
     * 单位：%
     * 必填: 是
     */
    @NotBlank
    private String maxSplitRatio;

    /**
     * 开通说明
     * 必填: 否
     */
    private String note;

    /**
     * 分账模式
     * 0-分账 1-归集
     * 必填: 是
     */
    @NotBlank
    private String productType;

    /**
     * 分账地区省市id
     * 必填: 是
     */
    @NotBlank
    private String provinceId;

    /**
     * 分账通道
     * 0-国通备付金
     * 必填: 是
     */
    @NotNull
    private Integer splitChannel;

    /**
     * 是否合并入账
     * 0-否 1-是
     * 必填: 是
     */
    @NotBlank
    private String mergeWithdraw;
}
