/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer.detail;

import lombok.Data;

/**
 * 客户结算账户信息
 *
 * @author wangyi
 * @version SplitSettlement.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class SplitSettlement {

    /**
     * 银行卡号
     * 必填: 是
     */
    private String cardNo;

    /**
     * 银行账户开户名
     * 客户类型为企业，使用企业对公账户开户名称
     * 客户类型为个人，使用身份证名称
     * 必填: 是
     */
    private String cardName;

    /**
     * 默认账户
     * 0否 1是，只允许一个默认账户
     * 必填: 是
     */
    private String isDefault;

    /**
     * 支行联行号
     * 结算类型为0-对公需上送
     * 调用数据字典-银行信息-查询联行号信息接口获取
     * 必填: 否
     */
    private String interbankNumber;

    /**
     * 支行省地区码
     * 调用数据字典-银行信息【获取银行省信息-联行号】获取
     * 必填: 否
     */
    private String provinceAreaCode;

    /**
     * 支行市地区码
     * 调用数据字典-银行信息【银行市信息-联行号接口】获取
     * 必填: 否
     */
    private String cityAreaCode;
}
