/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer.detail;

import lombok.Data;

/**
 * 编辑客户基础信息
 *
 * @author wangyi
 * @version CustomerEditInfo.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class CustomerEditInfo {

    /**
     * 商户编号
     * 分账商户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String custId;

    /**
     * 客户编号
     * 分账接收方客户编号，custId、customerId必须送一个优先匹配custId
     * 必填: 否
     */
    private String customerId;

    /**
     * 联系手机号
     * 必填: 是
     */
    private String phoneNo;

    /**
     * 标签
     * 必填: 否
     */
    private String tag;

    /**
     * 到账方式
     * 0直接到卡 1手工提现
     * 必填: 是
     */
    private String receiptType;

    /**
     * 结算周期
     * 0:D0 1:T1 2:D1
     * receiptType为1手工提现则settlementCycle使用0:D0
     * 必填: 是
     */
    private String settlementCycle;
}
