/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.request.share.customer;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.share.customer.detail.AttachmentInfo;
import com.fshows.postar.request.share.customer.detail.CustomerBaseInfoSimple;
import com.fshows.postar.request.share.customer.detail.SplitSettlement;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotEmpty;
import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 替换客户结算卡(XZY022)请求
 *
 * @author wangyi
 * @version PostarEditCustomerSettlementReq.java, v 0.1 2025-12-10 wangyi
 */
@Data
public class PostarEditCustomerSettlementReq extends PostarBaseReq {

    /**
     * 请求时间戳
     * 格式：yyyyMMddHHmmss
     * 必填: 是
     */
    @NotBlank
    private String timestamp;

    /**
     * 客户基础信息
     * 必填: 是
     */
    @NotNull
    private CustomerBaseInfoSimple customerBaseInfo;

    /**
     * 客户结算账户信息
     * 必填: 是
     */
    @NotEmpty
    private List<SplitSettlement> splitSettlementList;

    /**
     * 附件信息
     * 必填: 否
     */
    private List<AttachmentInfo> attachmentList;
}
