/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.share.PostarShareSplitReq;
import com.fshows.postar.request.share.account.PostarSettleAmtQueryReq;
import com.fshows.postar.request.share.collect.PostarAuthorizationCollectReq;
import com.fshows.postar.request.share.collect.PostarCollectAcntQueryReq;
import com.fshows.postar.request.share.collect.PostarCollectMergeReceiptReq;
import com.fshows.postar.request.share.collect.PostarCollectQueryReq;
import com.fshows.postar.request.share.collect.PostarCollectReceiptReq;
import com.fshows.postar.request.share.collect.PostarCollectReq;
import com.fshows.postar.request.share.collect.PostarCollectRevokeReq;
import com.fshows.postar.request.share.collect.PostarEditCollectInfoReq;
import com.fshows.postar.request.share.collect.PostarEditCollectStatusReq;
import com.fshows.postar.request.share.collect.PostarQueryCollectCustomerInfoReq;
import com.fshows.postar.request.share.common.PostarUploadFileReq;
import com.fshows.postar.request.share.customer.PostarAddCustomerReq;
import com.fshows.postar.request.share.customer.PostarAuthorizationSplitBatchReq;
import com.fshows.postar.request.share.customer.PostarAuthorizationSplitReq;
import com.fshows.postar.request.share.customer.PostarEditCustomerReq;
import com.fshows.postar.request.share.customer.PostarEditCustomerSettlementReq;
import com.fshows.postar.request.share.customer.PostarEditCustomerStatusReq;
import com.fshows.postar.request.share.customer.PostarQuerySplitCustomerInfoReq;
import com.fshows.postar.request.share.dict.PostarGetAreaReq;
import com.fshows.postar.request.share.dict.PostarGetBankCityReq;
import com.fshows.postar.request.share.dict.PostarGetBankInfoReq;
import com.fshows.postar.request.share.dict.PostarGetBankProvinceReq;
import com.fshows.postar.request.share.dict.PostarGetBranchInfoReq;
import com.fshows.postar.request.share.dict.PostarGetCityReq;
import com.fshows.postar.request.share.dict.PostarGetProvinceReq;
import com.fshows.postar.request.share.dict.PostarQueryInfoByCardReq;
import com.fshows.postar.request.share.product.PostarAddProductReq;
import com.fshows.postar.request.share.product.PostarEditInvoiceProductReq;
import com.fshows.postar.request.share.product.PostarEditProductReq;
import com.fshows.postar.request.share.product.PostarEffectiveStatusEditReq;
import com.fshows.postar.request.share.product.PostarProductDetailReq;
import com.fshows.postar.request.share.split.PostarAcntQueryReq;
import com.fshows.postar.request.share.split.PostarSplitMergeReceiptReq;
import com.fshows.postar.request.share.split.PostarSplitQueryReq;
import com.fshows.postar.request.share.split.PostarSplitReceiptReq;
import com.fshows.postar.request.share.split.PostarSplitRevokeReq;
import com.fshows.postar.request.share.split.PostarSubAccountTransReq;
import com.fshows.postar.request.share.withdraw.PostarCustomerWithdrawReq;
import com.fshows.postar.request.share.withdraw.PostarWithdrawQueryReq;
import com.fshows.postar.request.share.withdraw.PostarWithdrawReceiptReq;
import com.fshows.postar.request.share.withdraw.PostarWithdrawReq;
import com.fshows.postar.response.share.PostarShareSplitRes;
import com.fshows.postar.response.share.account.PostarSettleAmtQueryRes;
import com.fshows.postar.response.share.collect.PostarAuthorizationCollectRes;
import com.fshows.postar.response.share.collect.PostarCollectAcntQueryRes;
import com.fshows.postar.response.share.collect.PostarCollectMergeReceiptRes;
import com.fshows.postar.response.share.collect.PostarCollectQueryRes;
import com.fshows.postar.response.share.collect.PostarCollectReceiptRes;
import com.fshows.postar.response.share.collect.PostarCollectRes;
import com.fshows.postar.response.share.collect.PostarCollectRevokeRes;
import com.fshows.postar.response.share.collect.PostarEditCollectInfoRes;
import com.fshows.postar.response.share.collect.PostarEditCollectStatusRes;
import com.fshows.postar.response.share.collect.PostarQueryCollectCustomerInfoRes;
import com.fshows.postar.response.share.common.PostarUploadFileRes;
import com.fshows.postar.response.share.customer.PostarAddCustomerRes;
import com.fshows.postar.response.share.customer.PostarAuthorizationSplitBatchRes;
import com.fshows.postar.response.share.customer.PostarAuthorizationSplitRes;
import com.fshows.postar.response.share.customer.PostarEditCustomerRes;
import com.fshows.postar.response.share.customer.PostarEditCustomerSettlementRes;
import com.fshows.postar.response.share.customer.PostarEditCustomerStatusRes;
import com.fshows.postar.response.share.customer.PostarQuerySplitCustomerInfoRes;
import com.fshows.postar.response.share.dict.PostarGetAreaRes;
import com.fshows.postar.response.share.dict.PostarGetBankCityRes;
import com.fshows.postar.response.share.dict.PostarGetBankInfoRes;
import com.fshows.postar.response.share.dict.PostarGetBankProvinceRes;
import com.fshows.postar.response.share.dict.PostarGetBranchInfoRes;
import com.fshows.postar.response.share.dict.PostarGetCityRes;
import com.fshows.postar.response.share.dict.PostarGetProvinceRes;
import com.fshows.postar.response.share.dict.PostarQueryInfoByCardRes;
import com.fshows.postar.response.share.product.PostarAddProductRes;
import com.fshows.postar.response.share.product.PostarEditInvoiceProductRes;
import com.fshows.postar.response.share.product.PostarEditProductRes;
import com.fshows.postar.response.share.product.PostarEffectiveStatusEditRes;
import com.fshows.postar.response.share.product.PostarProductDetailRes;
import com.fshows.postar.response.share.split.PostarAcntQueryRes;
import com.fshows.postar.response.share.split.PostarSplitMergeReceiptRes;
import com.fshows.postar.response.share.split.PostarSplitQueryRes;
import com.fshows.postar.response.share.split.PostarSplitReceiptRes;
import com.fshows.postar.response.share.split.PostarSplitRevokeRes;
import com.fshows.postar.response.share.split.PostarSubAccountTransRes;
import com.fshows.postar.response.share.withdraw.PostarCustomerWithdrawRes;
import com.fshows.postar.response.share.withdraw.PostarWithdrawQueryRes;
import com.fshows.postar.response.share.withdraw.PostarWithdrawReceiptRes;
import com.fshows.postar.response.share.withdraw.PostarWithdrawRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿分账相关API
 *
 * @author wangyi
 * @version PostarShareApiEnum.java, v 0.1 2025-12-10 09:19 wangyi
 */
public enum PostarShareApiEnum implements IApiDefinition {

    /**
     * 分账接口
     */
    SPLIT(
            "分账",
            "/yyfsevr/trans/xzy/split",
            PostarConstant.DEFAULT_API_VERSION,
            PostarShareSplitReq.class,
            PostarShareSplitRes.class
    ),

    // ==================== 数据字典-地区码 ====================

    /**
     * 获取省
     */
    GET_PROVINCE(
            "获取省",
            "/yyfsevr/addCust/getProvince",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetProvinceReq.class,
            PostarGetProvinceRes.class
    ),

    /**
     * 获取市
     */
    GET_CITY(
            "获取市",
            "/yyfsevr/addCust/getCity",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetCityReq.class,
            PostarGetCityRes.class
    ),

    /**
     * 获取区县
     */
    GET_AREA(
            "获取区县",
            "/yyfsevr/addCust/getArea",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetAreaReq.class,
            PostarGetAreaRes.class
    ),

    // ==================== 数据字典-银行信息 ====================

    /**
     * 获取银行省信息-联行号
     */
    GET_BANK_PROVINCE(
            "获取银行省信息-联行号",
            "/yyfsevr/addCust/getPublicProvince",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetBankProvinceReq.class,
            PostarGetBankProvinceRes.class
    ),

    /**
     * 获取银行市信息-联行号
     */
    GET_BANK_CITY(
            "获取银行市信息-联行号",
            "/yyfsevr/addCust/getPublicCity",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetBankCityReq.class,
            PostarGetBankCityRes.class
    ),

    /**
     * 查询联行号信息
     */
    GET_BRANCH_INFO(
            "查询联行号信息",
            "/yyfsevr/addCust/getBranchInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetBranchInfoReq.class,
            PostarGetBranchInfoRes.class
    ),

    /**
     * 银行信息查询
     */
    GET_BANK_INFO(
            "银行信息查询",
            "/yyfsevr/addCust/getBankInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarGetBankInfoReq.class,
            PostarGetBankInfoRes.class
    ),

    /**
     * 根据银行卡号获取银行信息
     */
    QUERY_INFO_BY_CARD(
            "根据银行卡号获取银行信息",
            "/yyfsevr/addCust/queryInfoByCard",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryInfoByCardReq.class,
            PostarQueryInfoByCardRes.class
    ),

    // ==================== 提现 ====================

    /**
     * 提现-客户(XZY034)
     */
    CUSTOMER_WITHDRAW(
            "提现-客户",
            "/yyfsevr/trans/xzy/customer/withdraw",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCustomerWithdrawReq.class,
            PostarCustomerWithdrawRes.class
    ),

    /**
     * 提现订单查询(XZY035)
     */
    WITHDRAW_QUERY(
            "提现订单查询",
            "/yyfsevr/trans/xzy/withdrawQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWithdrawQueryReq.class,
            PostarWithdrawQueryRes.class
    ),

    /**
     * 提现(XZY036)
     */
    WITHDRAW(
            "提现",
            "/yyfsevr/trans/xzy/withdraw",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWithdrawReq.class,
            PostarWithdrawRes.class
    ),

    /**
     * 提现电子回单下载(XZY040)
     */
    WITHDRAW_RECEIPT(
            "提现电子回单下载",
            "/yyfsevr/trans/xzy/withdraw/receipt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarWithdrawReceiptReq.class,
            PostarWithdrawReceiptRes.class
    ),

    // ==================== 功能开通 ====================

    /**
     * 功能开通(XZY001)
     */
    ADD_PRODUCT(
            "功能开通",
            "/yyfsevr/manage/ryf/product/addProduct",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAddProductReq.class,
            PostarAddProductRes.class
    ),

    /**
     * 编辑上传付款凭证(XZY002)
     */
    EDIT_INVOICE_PRODUCT(
            "编辑上传付款凭证",
            "/yyfsevr/manage/ryf/product/editInvoiceProduct",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditInvoiceProductReq.class,
            PostarEditInvoiceProductRes.class
    ),

    /**
     * 编辑(XZY003)
     */
    EDIT_PRODUCT(
            "编辑",
            "/yyfsevr/manage/ryf/product/editProduct",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditProductReq.class,
            PostarEditProductRes.class
    ),

    /**
     * 修改生效状态(XZY004)
     */
    EFFECTIVE_STATUS_EDIT(
            "修改生效状态",
            "/yyfsevr/manage/ryf/product/effectiveStatusEdit",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEffectiveStatusEditReq.class,
            PostarEffectiveStatusEditRes.class
    ),

    /**
     * 查询详情信息(XZY005)
     */
    PRODUCT_DETAIL(
            "查询详情信息",
            "/yyfsevr/manage/ryf/product/productDetail",
            PostarConstant.DEFAULT_API_VERSION,
            PostarProductDetailReq.class,
            PostarProductDetailRes.class
    ),

    // ==================== 公共接口 ====================

    /**
     * 上传文件(XZY013)
     */
    UPLOAD_FILE(
            "上传文件",
            "/yyfsevr/manage/ryf/uploadFile",
            PostarConstant.DEFAULT_API_VERSION,
            PostarUploadFileReq.class,
            PostarUploadFileRes.class
    ),

    // ==================== 分账-交易 ====================

    /**
     * 订单查询(XZY015)
     */
    SPLIT_QUERY(
            "订单查询",
            "/yyfsevr/trans/xzy/splitQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSplitQueryReq.class,
            PostarSplitQueryRes.class
    ),

    /**
     * 分账撤销退回(XZY017)
     */
    SPLIT_REVOKE(
            "分账撤销退回",
            "/yyfsevr/trans/xzy/splitRevoke",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSplitRevokeReq.class,
            PostarSplitRevokeRes.class
    ),

    /**
     * 分账结算电子回单下载(XZY037)
     */
    SPLIT_RECEIPT(
            "分账结算电子回单下载",
            "/yyfsevr/trans/xzy/split/receipt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSplitReceiptReq.class,
            PostarSplitReceiptRes.class
    ),

    /**
     * 分账合并入账电子回单下载(XZY039)
     */
    SPLIT_MERGE_RECEIPT(
            "分账合并入账电子回单下载",
            "/yyfsevr/trans/xzy/splitMerge/receipt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSplitMergeReceiptReq.class,
            PostarSplitMergeReceiptRes.class
    ),

    /**
     * 余额查询接口(XZY041)
     */
    ACNT_QUERY(
            "余额查询",
            "/yyfsevr/trans/xzy/acnt/query",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAcntQueryReq.class,
            PostarAcntQueryRes.class
    ),

    /**
     * 子户转账(XZY046)
     */
    SUB_ACCOUNT_TRANS(
            "子户转账",
            "/yyfsevr/trans/xzy/trans",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSubAccountTransReq.class,
            PostarSubAccountTransRes.class
    ),

    // ==================== 分账-客户管理 ====================

    /**
     * 新增客户(XZY018)
     */
    ADD_CUSTOMER(
            "新增客户",
            "/yyfsevr/manage/ryf/customer/addCustomer",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAddCustomerReq.class,
            PostarAddCustomerRes.class
    ),

    /**
     * 合作状态调整(XZY020)
     */
    EDIT_CUSTOMER_STATUS(
            "合作状态调整",
            "/yyfsevr/manage/ryf/customer/editCustomerStatus",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditCustomerStatusReq.class,
            PostarEditCustomerStatusRes.class
    ),

    /**
     * 查询分账客户信息(XZY021)
     */
    QUERY_SPLIT_CUSTOMER_INFO(
            "查询分账客户信息",
            "/yyfsevr/manage/ryf/cust/querySplitCustomerInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQuerySplitCustomerInfoReq.class,
            PostarQuerySplitCustomerInfoRes.class
    ),

    /**
     * 替换客户结算卡(XZY022)
     */
    EDIT_CUSTOMER_SETTLEMENT(
            "替换客户结算卡",
            "/yyfsevr/manage/ryf/customer/editCustomerSettlement",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditCustomerSettlementReq.class,
            PostarEditCustomerSettlementRes.class
    ),

    /**
     * 编辑客户(XZY023)
     */
    EDIT_CUSTOMER(
            "编辑客户",
            "/yyfsevr/manage/ryf/customer/editCustomer",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditCustomerReq.class,
            PostarEditCustomerRes.class
    ),

    /**
     * 分账授权申请接口-收单统一结算(XZY043)
     */
    AUTHORIZATION_SPLIT(
            "分账授权申请",
            "/yyfsevr/manage/ryf/cust/authorizationSplit",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAuthorizationSplitReq.class,
            PostarAuthorizationSplitRes.class
    ),

    /**
     * 批量分账授权申请接口-收单统一结算(XZY044)
     */
    AUTHORIZATION_SPLIT_BATCH(
            "批量分账授权申请",
            "/yyfsevr/manage/ryf/cust/authorizationSplitBatch",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAuthorizationSplitBatchReq.class,
            PostarAuthorizationSplitBatchRes.class
    ),

    // ==================== 归集-开户/授权 ====================

    /**
     * 归集授权申请接口-收单统一结算(XZY037)
     */
    AUTHORIZATION_COLLECT(
            "归集授权申请",
            "/yyfsevr/manage/ryf/cust/authorizationCollect",
            PostarConstant.DEFAULT_API_VERSION,
            PostarAuthorizationCollectReq.class,
            PostarAuthorizationCollectRes.class
    ),

    /**
     * 归集合作状态调整(XZY026)
     */
    EDIT_COLLECT_STATUS(
            "归集合作状态调整",
            "/yyfsevr/manage/ryf/collect/editCollectStatus",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditCollectStatusReq.class,
            PostarEditCollectStatusRes.class
    ),

    /**
     * 查询归集客户信息(XZY027)
     */
    QUERY_COLLECT_CUSTOMER_INFO(
            "查询归集客户信息",
            "/yyfsevr/manage/ryf/cust/queryCollectCustomerInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryCollectCustomerInfoReq.class,
            PostarQueryCollectCustomerInfoRes.class
    ),

    /**
     * 编辑归集信息(XZY029)
     */
    EDIT_COLLECT_INFO(
            "编辑归集信息",
            "/yyfsevr/manage/ryf/collect/editCollectInfo",
            PostarConstant.DEFAULT_API_VERSION,
            PostarEditCollectInfoReq.class,
            PostarEditCollectInfoRes.class
    ),

    // ==================== 归集-交易 ====================

    /**
     * 归集(XZY030)
     */
    COLLECT(
            "归集",
            "/yyfsevr/trans/xzy/collect",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectReq.class,
            PostarCollectRes.class
    ),

    /**
     * 归集订单查询(XZY031)
     */
    COLLECT_QUERY(
            "归集订单查询",
            "/yyfsevr/trans/xzy/collectQuery",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectQueryReq.class,
            PostarCollectQueryRes.class
    ),

    /**
     * 归集撤销退回(XZY033)
     */
    COLLECT_REVOKE(
            "归集撤销退回",
            "/yyfsevr/trans/xzy/collectRevoke",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectRevokeReq.class,
            PostarCollectRevokeRes.class
    ),

    /**
     * 归集结算电子回单下载(XZY038)
     */
    COLLECT_RECEIPT(
            "归集结算电子回单下载",
            "/yyfsevr/trans/xzy/collect/receipt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectReceiptReq.class,
            PostarCollectReceiptRes.class
    ),

    /**
     * 归集合并入账电子回单下载(XZY040)
     */
    COLLECT_MERGE_RECEIPT(
            "归集合并入账电子回单下载",
            "/yyfsevr/trans/xzy/collectMerge/receipt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectMergeReceiptReq.class,
            PostarCollectMergeReceiptRes.class
    ),

    /**
     * 归集余额查询接口(XZY042)
     */
    COLLECT_ACNT_QUERY(
            "归集余额查询",
            "/yyfsevr/trans/xzy/collect/acnt/query",
            PostarConstant.DEFAULT_API_VERSION,
            PostarCollectAcntQueryReq.class,
            PostarCollectAcntQueryRes.class
    ),

    // ==================== 账户 ====================

    /**
     * 结算资金流水查询(XZY047)
     */
    SETTLE_AMT_QUERY(
            "结算资金流水查询",
            "/yyfsevr/trans/xzy/settleAmt",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSettleAmtQueryReq.class,
            PostarSettleAmtQueryRes.class
    ),

    ;

    /**
     * 接口名称
     */
    private String name;

    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;

    /**
     * 接口版本，默认1.0
     */
    private String version;

    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;

    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;

    PostarShareApiEnum(String name,
                       String apiSubURI,
                       String version,
                       Class requestClass,
                       Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}
