package com.fshows.postar.apienum;

import com.fshows.postar.contant.PostarConstant;
import com.fshows.postar.request.bankactivity.PostarQueryActSubReq;
import com.fshows.postar.request.bankactivity.PostarQuerySignUpActSubReq;
import com.fshows.postar.request.bankactivity.PostarSignUpActSubReq;
import com.fshows.postar.response.PostarBizRes;
import com.fshows.postar.response.bankactivity.PostarQueryActSubRes;
import com.fshows.postar.response.bankactivity.PostarQueryActSubDetailRes;
import com.fshows.postar.response.bankactivity.PostarQuerySignUpActSubRes;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;

/**
 * 国通星驿交易相关API
 *
 * @author liluqing
 * @version PostarTradeApiEnum.java, v 0.1 2022-03-01 21:53 liluqing
 */
public enum PostarBankActivityApiEnum implements IApiDefinition {

    /**
     * 活动列表查询
     */
    ACTIVITY_LIST_QUERY(
            "银行补贴活动查询",
            "/yyfsevr/addCust/queryActSub",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQueryActSubReq.class,
            PostarQueryActSubRes.class
    ),
    /**
     * 商户报名补贴活动
     */
    ACTIVITY_SIGN_UP(
            "商户报名补贴活动",
            "/yyfsevr/addCust/signUpActSub",
            PostarConstant.DEFAULT_API_VERSION,
            PostarSignUpActSubReq.class,
            PostarBizRes.class
    ),
    /**
     * 商户报名情况查询
     */
    ACTIVITY_SIGN_UP_QUERY(
            "商户报名情况查询",
            "/yyfsevr/addCust/querySignUpActSub",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQuerySignUpActSubReq.class,
            PostarQuerySignUpActSubRes.class
    ),
    /**
     * 商户补贴活动明细
     */
    ACTIVITY_SIGN_UP_DETAIL(
            "商户补贴活动明细",
            "/yyfsevr/addCust/queryActSubDetail",
            PostarConstant.DEFAULT_API_VERSION,
            PostarQuerySignUpActSubReq.class,
            PostarQueryActSubDetailRes.class
    ),
    ;

    /**
     * 接口名称
     */
    private String name;
    /**
     * 接口uri子资源路径
     */
    private String apiSubURI;
    /**
     * 接口版本，默认1.0
     */
    private String version;
    /**
     * 请求业务参数的Class类型
     */
    private Class requestClass;
    /**
     * 响应业务参数的Class类型
     */
    private Class responseClass;


    PostarBankActivityApiEnum(String name,
                              String apiSubURI,
                              String version,
                              Class requestClass,
                              Class responseClass) {
        this.name = name;
        this.apiSubURI = apiSubURI;
        this.version = version;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }

    @Override
    public String getApiURI() {
        return apiSubURI;
    }


    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
}