/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarCommonChangeReq.java, v 0.1 2024-10-09 09:53 weikunpeng
 */
@Data
public class PostarCommonChangeReq extends PostarBaseReq {

    /**
     * 进件机构号
     * 说明: 若“机构号”字段为虚拟机构号，则“进件机构号”字段必传
     * 必传: 否
     */
    private String applyAgentId;

    /**
     * 商户号
     * 必传: 是
     */
    @NotBlank
    private String custId;

    /**
     * 登入账号（手机号）
     * 说明: 该手机号可登录国通商户APP
     * 必传: 是
     */
    @NotBlank
    private String custLogin;

    /**
     * 商户名称
     * 说明: 不可为空，不超过50个字段（100个字符），需与营业执照、登记许可证、事业单位法人证书名一致
     * 必传: 是
     */
    @NotBlank
    private String busName;

    /**
     * 商户简称
     * 说明: 建议输入市+名称+主营，长度控制在50个字以内（100个字符以内），建议长度5-20个字（10-40个字符）。
     * 不足5个字的将补充“省市”信息，超出20个字的将截取后20位
     * 必传: 是
     */
    @NotBlank
    private String refName;

    /**
     * 营业执照号
     * 必传: 是
     */
    @NotBlank
    private String licenseno;

    /**
     * 营业执照有效期开始日期
     * 说明: 格式为YYYYMMDD
     * 必传: 是
     */
    @NotBlank
    private String busStartDate;

    /**
     * 营业执照有效期结束日期
     * 说明: 格式为YYYYMMDD，永久传"长期"
     * 必传: 是
     */
    @NotBlank
    private String busEndDate;

    /**
     * 主体类型
     * 说明: 1个体工商户，2企业，3政府及事业单位，5其他机构组织
     * 必传: 是
     */
    @NotBlank
    private String busType;

    /**
     * 证书类型
     * 说明: 当主体是事业单位和其他机构时必传
     * 可选值:
     * 1.事业单位法人证书
     * 2.统一社会信用代码证书
     * 3.有偿服务许可证（军队医院适用）
     * 4.医疗机构执业许可证（军队医院适用）
     * 5.企业营业执照（挂靠企业的党组织适用）
     * 6.机构组织代码证（政府机关适用）
     * 7.其他证书/批文/证明
     * 8.社会团体法人登记证书
     * 9.民办非企业单位登记证书
     * 10.基金会法人登记证书
     * 11.慈善组织公开募捐资格证书
     * 12.农民专业合作社法人营业执照
     * 13.宗教活动场所登记证书
     * 必传: 否
     */
    private String certType;

    /**
     * 行业类型ID
     * 说明: 该字段根据二级MCC目录对应行业编号
     * 必传: 是
     * 后续: 国通不能修改，并且也不需要传递了
     */
//    @NotBlank
//    private String mcccode;

    /**
     * 省
     * 说明: 通过基础信息获取板块-“获取省”接口获取
     * 必传: 是
     */
    @NotBlank
    private String provId;

    /**
     * 市
     * 说明: 通过基础信息获取板块-“获取市”接口获取
     * 必传: 是
     */
    @NotBlank
    private String cityId;

    /**
     * 区/县
     * 说明: 通过基础信息获取板块-“获取区县”接口获取
     * 必传: 是
     */
    @NotBlank
    private String areaId;

    /**
     * 商户经营地址
     * 说明: 长度控制在100个字（200个字符），建议长度5-30个字（10-60个字符）。
     * 系统将根据银联规范对地址进行长度补充与截取，少于5个字添加省市区进行补足，超过30个字的向后取值30个字
     * 必传: 是
     */
    @NotBlank
    private String custAddr;

    /**
     * 经营者姓名 (必填)
     */
    @NotBlank
    private String custName;

    /**
     * 身份证号码 (必填)
     */
    @NotBlank
    private String credNo;

    /**
     * 法人身份证有效期开始日期 (必填)
     * 格式: YYYYMMDD
     */
    @NotBlank
    private String credStartDate;

    /**
     * 法人身份证有效期结束日期 (必填)
     * 格式: YYYYMMDD，永久传"长期"
     */
    @NotBlank
    private String credEndDate;

    /**
     * 手机号码 (必填)
     * 经营者联系方式，可与“登入账号”一致
     */
    @NotBlank
    private String mobileNo;

    /**
     * 账户结算类型 (必填)
     * 01 对公
     * 02 法人对私
     * 03 非法人对私
     * 示例: 02
     */
    @NotBlank
    private String accountType;

    /**
     * 结算户名 (必填)
     * 默认结算人姓名
     */
    @NotBlank
    private String accountName;

    /**
     * 结算账号 (必填)
     */
    @NotBlank
    private String accountNo;

    /**
     * 开户行（银行缩写） (必填)
     * 调用基础信息板块-银行信息查询/根据银行卡号获取银行信息获取
     */
    @NotBlank
    private String bankCode;

    /**
     * 支行名称 (必填)
     * 调用基础信息板块-查询联行号信息接口获取
     */
    @NotBlank
    private String branchname;

    /**
     * 开户支行联行号 (可选)
     * 调用基础信息板块-查询联行号信息接口获取
     */
    private String bankno;

    /**
     * 非法人结算人姓名 (可选)
     * 非法人对私时填写
     */
    private String stlName;

    /**
     * 非法人结算人证件号码 (可选)
     * 非法人对私时填写
     */
    private String accCredNo;

    /**
     * 非法人结算人证件有效期开始 (可选)
     * 非法人对私时填写，格式: YYYYMMDD
     */
    private String accCredStartDate;

    /**
     * 非法人结算人证件有效期结束 (可选)
     * 非法人对私时填写，格式: YYYYMMDD，永久传"长期"
     */
    private String accCredEndDate;

    /**
     * 微信借记卡费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String rateWx;

    /**
     * 提现D1附加手续费 (必填)
     * 单位%，小数点后两位，结算类型为T1时传空值
     */
    private String rateTx;

    /**
     * 结算类型 (必填)
     * 1：T1 2：D1，若需开通D0可前往国通商户APP开通或联系联调人员获取D0-SDK主键嵌入自有程序。
     */
    @NotBlank
    private String stlType;

    /**
     * 微信贷记卡费率 (可选)
     * 单位%，支持小数点后三位
     */
    private String rateWxDj;

    /**
     * 支付宝扣率% (必填)
     * 单位%，支持小数点后三位
     */
    private String rateZfb;

    /**
     * 银联扫码借记卡扣率小于1000费率 % (必填)
     * 单位%，支持小数点后三位
     */
    private String rateYlCap0;

    /**
     * 银联扫码借记卡扣率大于1000费率 % (必填)
     * 单位%，支持小数点后三位
     */
    private String rateYlCap1;

    /**
     * 银联扫码贷记卡扣率小于1000费率 % (必填)
     * 单位%，支持小数点后三位
     */
    private String rateYlRat0;

    /**
     * 银联扫码贷记卡扣率大于1000费率 % (必填)
     * 单位%，支持小数点后三位
     */
    private String rateYlRat1;

    /**
     * 借记卡优惠类结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosJy;

    /**
     * 借记卡标准类结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosJb;

    /**
     * 贷记卡优惠类结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosDy;

    /**
     * 贷记卡标准类结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosDb;

    /**
     * 借记卡优惠类消费封顶值 (必填)
     * 单位分
     */
    private String moneyPosJy;

    /**
     * 借记卡标准类消费封顶值 (必填)
     * 单位分
     */
    private String moneyPosJb;

    /**
     * 免签免密结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosM;

    /**
     * 刷卡闪付结算费率 (必填)
     * 单位%，支持小数点后三位
     */
    private String ratePosS;

    /**
     * 抖音费率（%）。
     * 单位%，支持小数点后三位。
     */
    private String dySettRate;

    /**
     * 银联扫码借记卡(≤1000)封顶值 (可选)
     * 单位分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）
     */
    private String ylJFdDef;

    /**
     * 银联扫码借记卡(>1000)封顶值 (可选)
     * 单位分，根据机构政策区间上送，未上送时会取政策的默认封顶值。
     * 若政策未配置封顶值，则无需上送（代表不封顶）
     */
    private String ylJFd2Def;

    /**
     * 关联落地银行机构号 (可选)
     * 当610机构类型为“行业代理/联合收单”时，可调用进件-基础信息获取-关联落地银行品牌查询、落地银行下级机构查询接口，获取落地银行。
     * 会校验结算卡是否属于落地银行。若商户已存在落地银行不允许修改（为空代表不修改原值）
     */
    private String fallAgetId;

    /**
     * 报备产品类型 (必填)
     * 0全产品 1扫码 2刷卡
     */
    @NotBlank
    private String custChanType;

    /**
     * 是否支持退款 (必填)
     * ‘0’关；‘1’开
     */
    @NotBlank
    private String refPower;

    /**
     * 经度 (必填)
     * 商户经营地址所在经度，小数点后仅支持上传后5位，进行截取
     */
    private String longitude;

    /**
     * 纬度 (必填)
     * 商户经营地址所在纬度，小数点后仅支持上传后5位，进行截取
     */
    private String latitude;

    /**
     * 图片接口时间戳 (必填)
     * 首次进件必传，若商户首次进件被驳回后无需修改图片则无需传输
     */
    @NotBlank
    private String timestamp;

}