/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.bankactivity.detail;

import lombok.Data;

import java.io.Serializable;

/**
 * 商户补贴活动明细数据
 *
 * @author 吴安 * @version QueryActSubDetailData.java, v 0.1 2024-11-25 15:09 吴安
 * @date 2024/11/25
 */
@Data
public class QueryActSubDetailData implements Serializable {
    /**
     * 商户号
     */
    private String custId;
    /**
     * 商户名称
     */
    private String custName;
    /**
     * 补贴编号
     */
    private String btId;
    /**
     * 补贴机构编号
     */
    private String btagetid;
    /**
     * 补贴机构名称
     */
    private String btagetname;
    /**
     * 补贴类型：1-服务商补贴，2-公司补贴，11-落地银行补贴
     */
    private String discountFlag;
    /**
     * 手续费总额度
     */
    private String totalSubsidy;
    /**
     * 手续费总剩余额度
     */
    private String surplusTotalSubsidy;
    /**
     * 手续费月额度
     */
    private String monthTotalSubidy;
    /**
     * 手续费月剩余额度
     */
    private String remainMonthTotalSubidy;
    /**
     * 交易额总剩余额度
     */
    private String txamtTotalSubsidy;
    /**
     * 交易额月额度
     */
    private String subTotalTxamtResidue;
    /**
     * 交易额月剩余额度
     */
    private String txamtMonthSubsidy;
    /**
     * 补贴商户类型：0-全部，1-普通商户，2-小微商户
     */
    private String subMonthTxamtResidue;
    /**
     * 创建新路径
     */
    private String custType;
    /**
     * 开始日期
     */
    private String beginDate;
    /**
     * 结束日期
     */
    private String endDate;
    /**
     * 状态：1-生效，0-失效
     */
    private String status;
}