/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.response.trade;

import com.fshows.postar.response.PostarBizRes;
import lombok.Data;

/**
 * @author wangqilei
 * @version PostarScanCardCreateRes.java, v 0.1 2024-06-05 5:39 PM wangqilei
 */
@Data
public class PostarScanCardCreateRes extends PostarBizRes {
    private static final long serialVersionUID = 2781968382173294426L;
    /**
     * 机构编号
     * 商户或机构的唯一标识
     * (必填)
     */
    private String agetId;

    /**
     * 第三方订单号（服务商订单）
     * (特殊必填)
     */
    private String threeOrderNo;

    /**
     * 商户实收金额
     * 单位分，原订单交易金额-官方商户出资金额-商户交易实收手续费
     * (选填)
     */
    private String netrAmt;

    /**
     * 原订单交易金额
     * 单位分
     * (必填)
     */
    private String txamt;

    /**
     * 商户交易实收手续费
     * 单位分
     * (特殊必填)
     */
    private String custFee;

    /**
     * 官方商户出资金额
     * 单位分，数币交易时，该值为优惠金额
     * (特殊必填)
     */
    private String custAmt;

    /**
     * 国通平台订单号
     * (必填)
     */
    private String orderNo;

    /**
     * 官方订单号，支付渠道的官方订单号
     * 微信/支付宝（目的通道流水号），银联（官方订单号）可用于退款
     * (特殊必填)
     */
    private String torderNo;

    /**
     * 消费者的OpenID
     * (特殊必填)
     */
    private String openId;

    /**
     * 交易发生的IP地址
     * (必填)
     */
    private String tradingIp;

    /**
     * 	订单完成时间
     * 	格式yyyyMMddHHmmss
     * (必填)
     */
    private String orderTime;

    /**
     * 卡类型
     * 01借记卡，02贷记卡，03其他
     * (特殊必填)
     */
    private String cardType;

    /**
     * 补贴类型
     * 0无，1机构补贴，2公司补贴，11落地机构补贴
     * (特殊必填)
     */
    private String discountFlag;

    /**
     * POS服务化第三方订单号
     * 用于国通设备，非接口交易时，异步订单生成
     * (特殊必填)
     */
    private String serverThreeOrderNo;

    /**
     * 银行英文缩写
     * (特殊必填)
     */
    private String bankCode;

    /**
     * 银行名称
     * (特殊必填)
     */
    private String bankName;
}