/**
 * fshows.com
 * Copyright (C) 2013-2024 All Rights Reserved.
 */
package com.fshows.postar.request.merchant;

import com.fshows.postar.request.PostarBaseReq;
import lombok.Data;

import javax.validation.constraints.NotBlank;

/**
 * @author weikunpeng
 * @version PostarReportQueryReq.java, v 0.1 2024-10-09 15:13 weikunpeng
 */
@Data
public class PostarReportQueryReq extends PostarBaseReq {
    /**
     * 商户号
     */
    @NotBlank
    private String custId;

    /**
     * 支付通道
     * 00 全部 01 银联微信 02 银联支付宝 12 收单刷卡 13 银联扫码（云闪付）
     */
    @NotBlank
    private String payWay;
}