/*
 * 51qbiz.id
 * Copyright (C) 2021-2023 All Rights Reserved.
 */
package com.fshows.postar.request.bankactivity;

import com.fshows.postar.request.PostarBaseReq;
import com.fshows.postar.request.bankactivity.detail.SignUpActAddInfo;
import lombok.Data;

import javax.validation.constraints.NotNull;
import java.util.List;

/**
 * 商户报名补贴活动请求
 * @author Xujianwei
 * @version PostarActSubReq.java, v 0.1 2024-11-22 16:14 Xujianwei
 */
@Data
public class PostarSignUpActSubReq extends PostarBaseReq {
    private static final long serialVersionUID = -482265402250676499L;

    /**
     * 商户号
     */
    @NotNull(message = "商户号不能为空")
    private String custId;
    /**
     * 银行补贴活动编号（通过查询接口获取）
     */
    @NotNull(message = "银行补贴活动编号不能为空")
    private String actId;
    /**
     * 报名方式：1-已开卡，0-未开卡
     */
    private String operType;
    /**
     * 开卡人姓名（operType==0时必填）
     */
    private String accountName;
    /**
     * 开卡人电话（operType==0时必填）
     */
    private String phone;
    /**
     * 开卡人所在地址（operType==0时必填）
     */
    private String addr;
    /**
     * 开卡人详细地址（operType==0时必填）
     */
    private String addrInfo;
    /**
     * 关联落地银行编号（进件-基础信息获取-落地银行下级机构查询接口获取）
     */
    private String fallAgetId;
    /**
     * 补充材料数组（通过查询接口获取）
     */
    private List<SignUpActAddInfo> addList;
    /**
     * 时间戳（yyyyMMddHHmmss）
     */
    private String timeStamp;

}
