package com.fshows.msfpay.response;

import com.fshows.msfpay.response.item.MsfpayFeeSubsidyDetailItemResponse;
import com.fshows.msfpay.response.item.MsfpayTransactionRefundDetailItemResponse;
import lombok.Data;

import java.math.BigDecimal;
import java.util.List;

/**
 * CAS008-交易状态查询响应
 */
@Data
public class MsfpayTransactionQueryResponse extends MsfpayBizResponse {

    /**
     * 原交易订单号
     * 必填: 是
     * 长度: 32
     */
    private String oritranflow;

    /**
     * 原交易状态
     * 必填: 是
     * 长度: 2
     * 说明: 01交易成功 02交易处理中 03交易失败
     */
    private String oritranstatus;

    /**
     * 原响应码
     * 必填: 是
     * 长度: 10
     */
    private String orirespcode;

    /**
     * 原响应信息
     * 必填: 是
     * 长度: 56
     */
    private String orirespmsg;

    /**
     * 交易完成时间
     * 必填: 否
     * 长度: 17
     * 说明: 订单生成时间，格式为 yyyyMMddHHmmssSSS
     */
    private String finishtime;

    /**
     * 支付银行类型
     * 必填: 否
     * 长度: 32
     * 说明: 同微信和支付宝 如ICBC_DEBIT
     */
    private String banktype;

    /**
     * 卡类型
     * 必填: 否
     * 长度: 2
     * 说明: 01 借记 02 贷记
     */
    private String bankCardType;

    /**
     * 渠道订单号
     * 必填: 否
     * 长度: 32
     */
    private String chlOrderId;

    /**
     * 渠道完成时间
     * 必填: 否
     * 长度: 18
     * 说明: yyyyMMddHHmmssSSS
     */
    private String chlFinishTime;

    /**
     * 有效结算金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 交易金额-免充值优惠金额 单位：元
     */
    private BigDecimal settleAmt;

    /**
     * 优惠金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal couponAmt;

    /**
     * 手续费
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal feeAmt;

    /**
     * 原交易交易码
     * 必填: 否
     * 长度: 6
     */
    private String oritrancode;

    /**
     * 支付用户标识
     * 必填: 否
     * 长度: 64
     * 说明: 购买者的微信openid/支付宝userid
     */
    private String openId;

    /**
     * 优惠详情
     * 必填: 否
     * 长度: 1024
     * 说明: 详细说明参见条码支付异步通知报文
     */
    private String promotionDetail;

    /**
     * 退款详情
     * 必填: 否
     * 说明: JSON数组的字符串，oritrancode=CAS006且queryOption=refundDetail时可能返回
     */
    private List<MsfpayTransactionRefundDetailItemResponse> refundDetail;

    /**
     * 手续费补贴总金额
     * 必填: 否
     * 长度: 16,2
     * 说明: 单位：元
     */
    private BigDecimal feeSubsidyAmtTotal;

    /**
     * 手续费补贴明细
     * 必填: 否
     * 长度: 1024
     * 说明: json格式，示例：[{"activityCode":"MkT1","couponCode":"MAC1","feeSubsidyAmt":0.01},{"activityCode":"MkT2","couponCode":"MAC2","feeSubsidyAmt":0.01}]
     * 对应对象: MsfpayFeeSubsidyDetailItemResponse
     */
    private List<MsfpayFeeSubsidyDetailItemResponse> feeSubsidyDetail;
}
