package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 企业商户参数
 * @author songjian * @version MsfpayEnterpriseMerchantRequest.java, v 0.1 2025-08-06 19:29 songjian
 */
@Data
public class MsfpayEnterpriseMerchantRequest {
    /**
     * 证件类型
     * 必填: 是
     * 长度: 3
     * 说明: 101：营业执照 X：其他
     */
    public String businessLicenseType;

    /**
     * 营业执照号
     * 必填: 是
     * 长度: 20
     */
    public String businessLicenseNo;

    /**
     * 营业执照照片
     * 必填: 否
     * 长度: 128
     * 说明: 1、企业商户、个体工商户上送；2、注册时可不上送，需按风控要求时效内补交
     */
    public String businessLicensePhoto;

    /**
     * ICP许可证号/ICP备案号
     * 必填: 否
     * 长度: 22
     */
    public String icpNo;

    /**
     * ICP许可证/ICP备案有效期
     * 必填: 否
     * 长度: 8
     * 说明: 长期: 99991231
     */
    public String icpValid;

    /**
     * 专营资质行业信息
     * 必填: 否
     * 长度: 1000
     * 说明: 企业商户根据情况选择性上送
     */
    public String franchisedLicences;

    /**
     * 经办人姓名
     * 必填: 是
     * 长度: 16
     */
    public String operatorName;

    /**
     * 经办人证件类型
     * 必填: 否
     * 长度: 2
     * 说明: 身份证、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国公民护照
     */
    public String operatorEidType;

    /**
     * 经办人证件号码
     * 必填: 否
     * 长度: 22
     */
    public String operatorEid;

    /**
     * 经办人地址
     * 必填: 否
     * 说明: 证件类型"身份证"：输入身份证上的地址；证件类型非身份证：输入经办人在中国大陆地区的联系地址
     */
    public String operatorAddr;

    /**
     * 经办人证件有效期开始日期
     * 必填: 否
     * 长度: 8
     * 说明: 格式：yyyymmdd，"经办人证件有效期开始日期"小于等于当前入网日期
     */
    public String operatorEidValidBegin;

    /**
     * 经办人证件有效期截止日期
     * 必填: 否
     * 长度: 8
     * 说明: 格式：yyyymmdd，"经办人证件有效期截止日期"大于等于当前入网日期；"经办人证件有效期截止日期"大于"经办人证件有效期开始日期"
     */
    public String operatorEidValid;

    /**
     * 经办人手机号
     * 必填: 是
     * 长度: 13
     */
    public String operatorMobile;

    /**
     * 经办人邮箱
     * 必填: 否
     * 长度: 50
     */
    public String operatorEmail;

    /**
     * 经办人证件正面照
     * 必填: 否
     * 长度: 128
     */
    public String operatorEidFrontPhoto;

    /**
     * 经办人证件反面照
     * 必填: 否
     * 长度: 128
     */
    public String operatorEidBackPhoto;

    /**
     * 法定代表人姓名
     * 必填: 是
     * 长度: 32
     */
    public String legalName;

    /**
     * 法定代表人证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 身份证、港澳居民来往内地通行证、台湾居民来往大陆通行证、外国公民护照
     */
    public String legalIdType;

    /**
     * 法定代表人证件号码
     * 必填: 是
     * 长度: 22
     */
    public String legalId;

    /**
     * 法定代表人地址
     * 必填: 否
     * 长度: 10-120
     * 说明: 证件类型"身份证"：输入身份证上的地址；证件类型非身份证：输入法定代表人在中国大陆地区的联系地址
     */
    public String legalAddr;

    /**
     * 法定代表人证件有效期开始日期
     * 必填: 是
     * 长度: 8
     * 说明: "法定代表人证件有效期开始日期"小于等于当前入网日期
     */
    public String legalIdValidBegin;

    /**
     * 法定代表人证件有效期截止日期
     * 必填: 是
     * 长度: 8
     * 说明: 长期: 99991231，"法定代表人证件有效期截止日期"大于等于当前入网日期；"法定代表人证件有效期截止日期"大于"法定代表人证件有效期开始日期"
     */
    public String legalIdValid;

    /**
     * 法定代表人证件正面照
     * 必填: 是
     * 长度: 128
     * 说明: 企业商户上送
     */
    public String legalIdFrontPhoto;

    /**
     * 法人身份证背面照
     * 必填: 是
     * 长度: 128
     * 说明: 企业商户上送
     */
    public String legalIdBackPhoto;

    /**
     * 受益所有人信息
     * 必填: 是
     * 长度: 1000
     */
    public String controllerInfos;

    /**
     * 受益所有人证件影像压缩文件
     * 必填: 是
     * 长度: 128
     * 说明: 仅支持压缩文件
     */
    public String controllerIdPhotoZip;

    /**
     * 专营资质证件影像压缩文件
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持压缩文件
     */
    public String franchisedLicencePhotoZip;

    /**
     * 门头照
     * 必填: 是
     * 长度: 128
     * 说明: 仅支持图片
     */
    public String storePhoto;

    /**
     * 内部经营照
     * 必填: 是
     * 长度: 128
     */
    public String storeInsidePhoto;

    /**
     * 法定代表人/经办人于经营场所手持营业执照照片
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片
     */
    public String holdingBusinessLicensePhoto;

    /**
     * 其他照片
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片
     */
    public String otherPhoto;

    /**
     * 商户网站地址
     * 必填: 否
     * 长度: 128
     */
    public String merchantUrl;

    /**
     * 企业经办人授权委托书扫描件
     * 必填: 否
     * 长度: 128
     * 说明: 1、企业商户上送 2、注册时可不上送，需按风控要求时效内补交
     */
    public String operatorAuthorizePhoto;

    /**
     * 银行账户开户证明文件
     * 必填: 是
     * 长度: 128
     * 说明: 具体开户证明文件可登录"中投科信支付"公众号-常见问题中查阅
     */
    public String openingNoPhoto;

    /**
     * 开户声明文件
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持图片，(法定代表人亲笔签名+加盖公章)原件；附《开户声明文件模板》
     */
    public String declaraPhoto;

    /**
     * 开户意愿视频
     * 必填: 否
     * 长度: 128
     * 说明: 仅支持mp4、mov视频格式，文件不大于10M；法定代表人在《开户声明》上签字的视频文件
     */
    public String wishVideo;
}
