package com.fshows.msfpay.request;

import com.fshows.msfpay.request.item.MsfpayMerRateItemListRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS014-二级商户签约请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayMerchantSignRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 页面通知地址
     * 必填: 否
     * 长度: 128
     * 说明: 签约报文信息通过该地址返回
     */
    private String weburl;

    /**
     * 服务器通知地址
     * 必填: 否
     * 长度: 128
     */
    private String serverurl;

    /**
     * 费率相关数据
     * 必填: 否
     * 长度: 2000
     * 说明: 费率签约方式为"二级商户签约费率"时必输，JSON格式
     * 对应对象: MsfpayMerRateItemListRequest
     */
    private MsfpayMerRateItemListRequest merratelist;

    /**
     * 验证令牌
     * 必填: 否
     * 长度: 50
     * 说明: 由CMS012返回
     */
    private String phonetoken;
}
