package com.fshows.msfpay.response;

import lombok.Data;

import java.util.List;

/**
 * CMS050-会员信息查询响应
 */
@Data
public class MsfpayMemberInfoQueryResponse extends MsfpayBizResponse {

    /**
     * 会员号码
     * 必填: 是
     * 长度: 64
     * 说明: USXXXXXXXXX
     */
    private String memUserId;

    /**
     * 会员状态
     * 必填: 是
     * 长度: 2
     * 说明: 00正常 01注销 02冻结 03初始 04锁定
     */
    private String memState;

    /**
     * 银行卡绑定状态
     * 必填: 否
     * 长度: 2
     * 说明: 00已绑定 01已解绑
     */
    private String bindCardStatus;

    /**
     * 会员绑卡信息
     * 必填: 否
     * 说明: bankcardno为空时且会员状态正常会返回
     */
    private List<MsfpayCardsResponse> cards;
}
