package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import java.math.BigDecimal;

/**
 * CAS057-查询分期期数请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayInstallmentPeriodsQueryRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     * 说明: 二级商户号
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 交易金额
     * 必填: 是
     * 长度: 14,2
     */
    @NotNull(message = "交易金额不能为空")
    private BigDecimal tranamt;

    /**
     * 分期期数
     * 必填: 否
     * 长度: 2
     * 说明：3/6/12
     */
    private String instalperiod;
}
