/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.msfpay.client;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.msfpay.apienum.MsfpayMerchantApiDefinitionEnum;
import com.fshows.msfpay.client.model.MsfpayMerchantClientConfigModel;
import com.fshows.msfpay.request.MsfpayBizRequest;
import com.fshows.msfpay.response.MsfpayBaseResponse;
import com.fshows.msfpay.utils.MsfpayUtil;
import com.fshows.msfpay.utils.SM2Utils;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import java.io.IOException;
import java.security.PrivateKey;
import java.util.HashMap;
import java.util.Map;
import msfpay.cfca.sadk.util.Base64;
import msfpay.cfca.sadk.util.CertUtil;
import msfpay.cfca.sadk.x509.certificate.X509Cert;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MsfpaySignApiClient
extends AbstractApiClient<MsfpayBizRequest, MsfpayBaseResponse, MsfpayMerchantApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(MsfpaySignApiClient.class);
    private PrivateKey merchantSignPrivateKey;
    private PrivateKey merchantEncPrivateKey;
    private X509Cert platformEncCert;
    private X509Cert platformSignCert;
    private X509Cert merchantEncCert;
    private X509Cert merchantSignCert;

    public MsfpaySignApiClient(MsfpayMerchantClientConfigModel apiClientConfig) throws Exception {
        super((DefaultClientConfigModel)apiClientConfig);
        this.initCertificatesAndKeys(apiClientConfig);
    }

    private void initCertificatesAndKeys(MsfpayMerchantClientConfigModel config) throws Exception {
        try {
            this.merchantSignPrivateKey = SM2Utils.getPrivateKeyFromSM2(config.getMerchantSignPath(), config.getMerchantSignPwd());
            this.merchantEncPrivateKey = SM2Utils.getPrivateKeyFromSM2(config.getMerchantEncPath(), config.getMerchantEncPwd());
            this.platformEncCert = MsfpayUtil.getX509Cert(config.getPlatformEncCertPath());
            this.platformSignCert = MsfpayUtil.getX509Cert(config.getPlatformSignCertPath());
            this.merchantEncCert = CertUtil.getCertFromSM2((String)config.getMerchantEncPath());
            this.merchantSignCert = CertUtil.getCertFromSM2((String)config.getMerchantSignPath());
            log.info("\u8bc1\u4e66\u548c\u5bc6\u94a5\u521d\u59cb\u5316\u6210\u529f");
        }
        catch (Exception e) {
            log.error("\u521d\u59cb\u5316\u8bc1\u4e66\u548c\u5bc6\u94a5\u5931\u8d25", (Throwable)e);
            throw new Exception("\u521d\u59cb\u5316\u8bc1\u4e66\u548c\u5bc6\u94a5\u5931\u8d25", e);
        }
    }

    protected DefaultRequestContext buildRequestContext(MsfpayMerchantApiDefinitionEnum iApiDefinition, MsfpayBizRequest request, DefaultClientConfigModel customConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition((IApiDefinition)iApiDefinition);
        MsfpayMerchantClientConfigModel config = new MsfpayMerchantClientConfigModel();
        MsfpayMerchantClientConfigModel clientConfig = (MsfpayMerchantClientConfigModel)this.apiClientConfig;
        config.setApiParentURL(clientConfig.getApiParentURL());
        config.setCharset(clientConfig.getCharset());
        config.setSignType(clientConfig.getSignType());
        config.setVersion(clientConfig.getVersion());
        config.setPlatmerid(clientConfig.getPlatmerid());
        config.setTimeout(clientConfig.getTimeout());
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(MsfpayBizRequest request, DefaultRequestContext context) {
        MsfpayMerchantClientConfigModel configModel = (MsfpayMerchantClientConfigModel)context.getApiClientConfig();
        MsfpayMerchantApiDefinitionEnum iApiDefinition = (MsfpayMerchantApiDefinitionEnum)context.getIApiDefinition();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        apiRequestModel.setApiURL(configModel.getApiParentURL());
        apiRequestModel.setContentType("application/x-www-form-urlencoded");
        try {
            this.fillCommonHead(request, configModel, iApiDefinition);
            apiRequestModel.setRequest((IRequestDefinition)request);
            HashMap<String, String> messageData = new HashMap<String, String>();
            HashMap dataMap = new HashMap();
            HashMap<String, String> headMap = new HashMap<String, String>();
            HashMap bodyMap = new HashMap();
            headMap.put("mertrandate", request.getMertrandate());
            headMap.put("mertrantime", request.getMertrantime());
            headMap.put("platmerid", request.getPlatmerid());
            headMap.put("trancode", request.getTrancode());
            headMap.put("tranflow", request.getTranflow());
            headMap.put("ztpage", request.getZtpage());
            headMap.put("respcode", "");
            headMap.put("respmsg", "");
            String requestJson = JSON.toJSONString((Object)request);
            Map requestMap = (Map)JSON.parseObject((String)requestJson, Map.class);
            requestMap.remove("platmerid");
            requestMap.remove("tranflow");
            requestMap.remove("trancode");
            requestMap.remove("mertrandate");
            requestMap.remove("mertrantime");
            requestMap.remove("ztpage");
            bodyMap.putAll(requestMap);
            dataMap.put("head", headMap);
            dataMap.put("body", bodyMap);
            String dataJson = JSON.toJSONString(dataMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
            String sign = this.sign(dataJson);
            messageData.put("data", dataJson);
            messageData.put("sign", sign);
            HashMap<String, HashMap<String, String>> message = new HashMap<String, HashMap<String, String>>();
            message.put("message", messageData);
            apiRequestModel.setParamMap(message);
            String messageJson = JSON.toJSONString(message, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty});
            byte[] envelopdata = SM2Utils.envelopeMessage(messageJson, "SM4/ECB/PKCS7Padding", this.platformEncCert);
            HashMap<String, String> paramMap = new HashMap<String, String>();
            paramMap.put("formatType", "json");
            paramMap.put("cryptType", "sm2");
            paramMap.put("signType", "sm2");
            paramMap.put("data", new String(envelopdata));
            apiRequestModel.setRequestForm(paramMap);
        }
        catch (Exception e) {
            throw new FsApiException("\u6784\u5efa\u8bf7\u6c42\u5931\u8d25", (Throwable)e);
        }
        return apiRequestModel;
    }

    private void fillCommonHead(MsfpayBizRequest request, MsfpayMerchantClientConfigModel configModel, MsfpayMerchantApiDefinitionEnum iApiDefinition) {
        if (StringUtils.isEmpty((CharSequence)request.getPlatmerid())) {
            request.setPlatmerid(configModel.getPlatmerid());
        }
        request.setTrancode(iApiDefinition.getTrancode());
        request.setMertrandate(MsfpayUtil.getCurrentDateTime("yyyyMMdd"));
        request.setMertrantime(MsfpayUtil.getCurrentDateTime("HHmmss"));
        request.setZtpage("false");
        if (request.getTranflow() == null || request.getTranflow().isEmpty()) {
            request.setTranflow(MsfpayUtil.generateTranflow(configModel.getPlatmerid()));
        }
    }

    private String sign(String content) {
        try {
            return SM2Utils.P7SignMessageDetach("sm3WithSM2Encryption", new String(Base64.encode((byte[])content.getBytes("UTF-8"))), this.merchantSignPrivateKey, this.merchantSignCert, SM2Utils.session);
        }
        catch (Exception e) {
            log.error("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
            throw new FsApiException("\u7b7e\u540d\u5931\u8d25", (Throwable)e);
        }
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u4e2d\u6295\u652f\u4ed8");
        clientInfoModel.setClientCode("msfpay-sdk");
        return clientInfoModel;
    }

    protected MsfpayBaseResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        JSONObject message = new JSONObject();
        message.put("serviceUrl", (Object)requestContext.getApiClientConfig().getApiParentURL());
        message.put("data", apiRequestModel.getRequestForm().get("data"));
        MsfpayBaseResponse baseResponse = new MsfpayBaseResponse();
        baseResponse.setCode("C000000000");
        baseResponse.setMsg("\u6210\u529f");
        IResponseDefinition iResponseDefinition = (IResponseDefinition)JSON.parseObject((String)message.toJSONString(), (Class)requestContext.getIApiDefinition().getResponseClass());
        baseResponse.setiResponseDefinition(iResponseDefinition);
        return baseResponse;
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext defaultRequestContext) throws IOException {
        return null;
    }

    public MsfpayBaseResponse execute(MsfpayBizRequest request, MsfpayMerchantApiDefinitionEnum apiDefinition) throws FsApiException {
        return (MsfpayBaseResponse)this.doExecute(request, apiDefinition);
    }

    public MsfpayBaseResponse execute(MsfpayBizRequest request, MsfpayMerchantApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected MsfpayBaseResponse doExecute(MsfpayBizRequest request, MsfpayMerchantApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)apiRequestModel.getParamMap())});
            long reqBeginTime = System.currentTimeMillis();
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqEndTime = System.currentTimeMillis();
            MsfpayBaseResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u7ed3\u675f >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getParamMap()), JSONObject.toJSONString((Object)response), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString(apiRequestModel), JSONObject.toJSONString(apiResponseModel)});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, JSONObject.toJSONString((Object)request), JSONObject.toJSONString(apiRequestModel), JSONObject.toJSONString(apiResponseModel)});
            throw new FsApiException("\u8bf7\u6c42\u672a\u77e5\u5f02\u5e38", (Throwable)e);
        }
    }
}

