package com.fshows.msfpay.response.item;

import lombok.Data;

/**
 * 活动补贴信息响应对象
 * 用于返回活动申请的处理结果
 */
@Data
public class MsfpayActDetailsResponse {

    /**
     * 活动编码
     * 必填: 是
     * 长度: 32
     * 说明: 活动的唯一标识编码
     */
    private String activityCode;

    /**
     * 活动名称
     * 必填: 是
     * 长度: 128
     * 说明: 活动的名称
     */
    private String activityName;

    /**
     * 状态
     * 必填: 是
     * 长度: 2
     * 说明: 活动申请状态
     * 00-待审核
     * 01-审核通过
     * 02-审核拒绝
     * 99-申请失败
     * 98-申请成功，但需人工介入（返回98时需联系客服处理）
     */
    private String state;

    /**
     * 失败原因
     * 必填: 否
     * 长度: 128
     * 说明: 当申请失败时返回具体的失败原因
     */
    private String actFailMsg;

    /**
     * 红包创建状态
     * 必填: 否
     * 长度: 2
     * 说明: 当申请活动状态为审核通过时返回
     * 01-创建成功
     * 02-创建失败
     */
    private String actCouponState;

    /**
     * 红包处理失败原因
     * 必填: 否
     * 长度: 128
     * 说明: 当红包创建失败时返回具体的失败原因
     */
    private String actCouponFailMsg;
}
