package com.fshows.msfpay.request.item;

import lombok.Data;

/**
 * 商品信息项
 */
@Data
public class MsfpayProductItemRequest {

    /**
     * 商品名称
     * 必填: 是
     * 长度: 100
     * 示例: 牙刷
     */
    private String productname;

    /**
     * 商品数量
     * 必填: 是
     * 长度: 10
     * 示例: 2
     */
    private String productnum;

    /**
     * 商品金额
     * 必填: 是
     * 长度: 16,2
     * 示例: 0.5
     * 说明: 以元为单位，保留小数2位
     */
    private String productamt;
} 