package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CMS011-条码支付开通请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayBarcodeOpenRequest extends MsfpayBizRequest {

    /**
     * 中投商户号
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "中投商户号不能为空")
    private String merid;

    /**
     * 通道类型
     * 必填: 是
     * 长度: 32
     * 说明: WEIXIN 微信、ALI 支付宝、UP 银联、HUABEI 花呗分期、UPXCX云微小程序
     */
    @NotBlank(message = "通道类型不能为空")
    private String chltype;

    /**
     * 银行商户号
     * 必填: 否
     * 长度: 32
     * 说明: 中投微信银行商户号/支付宝appid/银联机构号，微信支付宝必填
     */
    private String mchid;

    /**
     * 渠道商户号
     * 必填: 否
     * 长度: 32
     * 说明: 微信必填
     */
    private String channelid;

    /**
     * 经营类目
     * 必填: 是
     * 长度: 10
     * 说明: 非微信类型必输
     */
    @NotBlank(message = "经营类目不能为空")
    private String industryid;

    /**
     * 微信结算规则id
     * 必填: 否
     * 长度: 10
     * 说明: 微信必输，根据实际情况上送结算规则ID
     */
    private String wxindustryid;

    /**
     * Appid
     * 必填: 否
     * 长度: 32
     * 说明: 支付宝pid/微信appid，支付宝必填
     */
    private String appid;

    /**
     * 客服电话
     * 必填: 是
     * 长度: 18
     * 说明: 只能是数字
     */
    @NotBlank(message = "客服电话不能为空")
    private String servtel;
}
