package com.fshows.msfpay.request;

import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;

/**
 * CAS028-协议签约请求
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class MsfpayAgreementSignRequest extends MsfpayBizRequest {

    /**
     * 商户id
     * 必填: 是
     * 长度: 12
     */
    @NotBlank(message = "商户id不能为空")
    private String merid;

    /**
     * 外部用户号
     * 必填: 否
     * 长度: 32
     */
    private String outuserid;

    /**
     * 账号
     * 必填: 是
     * 长度: 32
     * 说明: 银行卡号或者存折号码
     */
    @NotBlank(message = "账号不能为空")
    private String accountno;

    /**
     * 账户名称
     * 必填: 是
     * 长度: 60
     * 说明: 银行卡或者存折上对应的名称
     */
    @NotBlank(message = "账户名称不能为空")
    private String accountname;

    /**
     * 开户证件类型
     * 必填: 是
     * 长度: 2
     * 说明: 01：身份证；目前仅支持身份证
     */
    @NotBlank(message = "开户证件类型不能为空")
    private String certtype;

    /**
     * 证件号
     * 必填: 是
     * 长度: 22
     * 说明: 身份证号码
     */
    @NotBlank(message = "证件号不能为空")
    private String certno;

    /**
     * 手机号
     * 必填: 是
     * 长度: 13
     * 说明: 银行预留手机号
     */
    @NotBlank(message = "手机号不能为空")
    private String mobileno;

    /**
     * 卡有效期
     * 必填: 否
     * 长度: 4
     * 说明: 卡号为借记卡时，无需输入
     */
    private String expireddate;

    /**
     * cvv2
     * 必填: 否
     * 长度: 3
     * 说明: 卡号为借记卡时，无需输入
     */
    private String cvv2;
}
