package com.fshows.msfpay.constant;

/**
 * 中投科信支付常量
 */
public class MsfpayConstant {
    /**
     * 签名类型常量
     */
    public static class SignType {
        /** RSA证书 */
        public static final String RSA = "rsa";
        /** SM2证书 */
        public static final String SM2 = "sm2";
    }

    /**
     * 报文字段名常量
     */
    public static class MessageField {
        /** 报文根节点 */
        public static final String MESSAGE = "message";
        /** 数据节点 */
        public static final String DATA = "data";
        /** 签名节点 */
        public static final String SIGN = "sign";
        /** 报文头节点 */
        public static final String HEAD = "head";
        /** 报文体节点 */
        public static final String BODY = "body";
    }

    /**
     * 报文头字段名常量
     */
    public static class HeadField {
        /** 商户交易日期 */
        public static final String MERTRANDATE = "mertrandate";
        /** 商户交易时间 */
        public static final String MERTRANTIME = "mertrantime";
        /** 交易时间（图片上传接口使用） */
        public static final String TRANTIME = "trantime";
        /** 平台商户号 */
        public static final String PLATMERID = "platmerid";
        /** 交易编码 */
        public static final String TRANCODE = "trancode";
        /** 交易流水号 */
        public static final String TRANFLOW = "tranflow";
        /** 响应码 */
        public static final String RESPCODE = "respcode";
        /** 响应信息 */
        public static final String RESPMSG = "respmsg";
        /** 是否页面 */
        public static final String ZTPAGE = "ztpage";
    }

    /**
     * 日期时间格式常量
     */
    public static class DateTimeFormat {
        /** 日期格式 */
        public static final String DATE_FORMAT = "yyyyMMdd";
        /** 时间格式 */
        public static final String TIME_FORMAT = "HHmmss";
        /** 完整日期时间格式 */
        public static final String DATETIME_FORMAT = "yyyyMMddHHmmss";
    }

    /**
     * HTTP相关常量
     */
    public static class Http {
        /** JSON内容类型 */
        public static final String CONTENT_TYPE_JSON = "application/json";
        /** 表单内容类型 */
        public static final String CONTENT_TYPE_FORM = "application/x-www-form-urlencoded";
        /** 字符编码 */
        public static final String CHARSET_UTF8 = "UTF-8";
    }

    /**
     * 布尔值字符串常量
     */
    public static class BooleanString {
        /** false字符串 */
        public static final String FALSE = "false";
        /** true字符串 */
        public static final String TRUE = "true";
    }

    /**
     * 加密相关常量
     */
    public static class Encryption {
        /** SM4加密算法 */
        public static final String SM4_ECB_PKCS7 = "SM4/ECB/PKCS7Padding";
        /** SM3WithSM2签名算法 */
        public static final String SM3_WITH_SM2 = "sm3WithSM2Encryption";
    }

    /**
     * 请求参数字段名常量
     */
    public static class RequestField {
        /** 格式类型 */
        public static final String FORMAT_TYPE = "formatType";
        /** 加密类型 */
        public static final String CRYPT_TYPE = "cryptType";
        /** 签名类型 */
        public static final String SIGN_TYPE = "signType";
        /** 数据字段 */
        public static final String DATA = "data";
        /** 图片字段 */
        public static final String IMGS = "imgs";
        /** 图片内容字段（用于签名验证） */
        public static final String IMG = "img";
    }

    /**
     * 请求参数值常量
     */
    public static class RequestValue {
        /** JSON格式 */
        public static final String FORMAT_JSON = "json";
        /** SM2加密 */
        public static final String CRYPT_SM2 = "sm2";
        /** SM2签名 */
        public static final String SIGN_SM2 = "sm2";
    }

    /**
     * 响应字段名常量
     */
    public static class ResponseField {
        /** 图片ID */
        public static final String PICTURE_ID = "pictureid";
        /** 响应码 */
        public static final String RESP_CODE = "respCode";
        /** 响应消息 */
        public static final String RESP_MSG = "respMsg";
        /** 代码 */
        public static final String CODE = "code";
        /** 消息 */
        public static final String MSG = "msg";
        /** 消息字段 */
        public static final String MESSAGE = "message";
        /** 主体字段 */
        public static final String BODY = "body";
        /** 交易流水 */
        public static final String TRANFLOW = "tranflow";
    }

    /**
     * 字符串处理常量
     */
    public static class StringPattern {
        /** 换行符 */
        public static final String LINE_FEED = "\\n";
        /** 回车符 */
        public static final String CARRIAGE_RETURN = "\\r";
        /** 空字符串 */
        public static final String EMPTY = "";
    }

    /**
     * 客户端信息常量
     */
    public static class ClientInfo {
        /** 客户端名称 */
        public static final String CLIENT_NAME = "中投支付";
        /** 客户端代码 */
        public static final String CLIENT_CODE = "msfpay-sdk";
    }

    /**
     * 网关地址配置
     */
    public static class Gateway {
        /** CMS网关地址（商户进件类） */
        public static final String CMS_GATEWAY = "https://www.umbpay.cn/cmsmeraccess/transV2/service.do";

        /** CAS网关地址（交易类） */
        public static final String CAS_GATEWAY = "https://www.umbpay.cn/cashier/transV2/service.do";

        /** CMS网关地址（图片上传） */
        public static final String CAS_IMG_GATEWAY = "https://www.umbpay.cn/cmsmeraccess/public/imageUploadV2.do";
    }
}
